/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.network.PacketDistributor;
import net.tropicraft.core.common.block.DrinkMixerBlock;
import net.tropicraft.core.common.block.tileentity.IMachineBlock;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.DrinkIngredient;
import net.tropicraft.core.common.network.message.ClientboundMixerInventoryPacket;
import net.tropicraft.core.common.network.message.ClientboundMixerStartPacket;
import org.slf4j.Logger;

public class DrinkMixerBlockEntity
extends BlockEntity
implements IMachineBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TICKS_TO_MIX = 80;
    private int ticks;
    private final List<ItemStack> drinkIngredients;
    private boolean mixing = false;
    public ItemStack result = ItemStack.EMPTY;

    public DrinkMixerBlockEntity(BlockEntityType<DrinkMixerBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.drinkIngredients = new ArrayList<ItemStack>();
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.ticks = input.getIntOr("MixTicks", 0);
        this.mixing = input.getBooleanOr("Mixing", false);
        this.setDrinkIngredients(input.read("ingredients", ItemStack.SINGLE_ITEM_CODEC.listOf()).orElse(List.of()));
        this.result = input.read("Result", ItemStack.CODEC).orElse(ItemStack.EMPTY);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putInt("MixTicks", this.ticks);
        output.putBoolean("Mixing", this.mixing);
        output.store("ingredients", ItemStack.SINGLE_ITEM_CODEC.listOf(), this.drinkIngredients);
        if (!this.result.isEmpty()) {
            output.store("Result", ItemStack.CODEC, (Object)this.result);
        }
    }

    public static void mixTick(Level level, BlockPos pos, BlockState state, DrinkMixerBlockEntity mixer) {
        mixer.tick();
    }

    private void tick() {
        if (this.ticks < 80 && this.mixing) {
            ++this.ticks;
            if (this.ticks == 80) {
                this.finishMixing();
            }
        }
    }

    public boolean isDoneMixing() {
        return !this.result.isEmpty();
    }

    public List<ItemStack> getDrinkIngredients() {
        return this.drinkIngredients;
    }

    public void setDrinkIngredients(List<ItemStack> ingredients) {
        this.drinkIngredients.clear();
        this.drinkIngredients.addAll(ingredients);
    }

    public boolean tryStartMixing() {
        if (this.mixing) {
            return false;
        }
        if (Drink.makeCocktail((HolderLookup.Provider)this.level.registryAccess(), this.drinkIngredients) == null) {
            return false;
        }
        this.ticks = 0;
        this.mixing = true;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new ClientboundMixerStartPacket(this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return true;
    }

    public void setMixing() {
        this.ticks = 0;
        this.mixing = true;
    }

    private void dropItem(ItemStack stack, @Nullable Player at) {
        if (at == null) {
            BlockPos pos = this.getBlockPos().relative((Direction)this.getBlockState().getValue(DrinkMixerBlock.FACING));
            Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        } else {
            Containers.dropItemStack((Level)this.level, (double)at.getX(), (double)at.getY(), (double)at.getZ(), (ItemStack)stack);
        }
    }

    public void emptyMixer(@Nullable Player at) {
        for (ItemStack stack : this.drinkIngredients) {
            this.dropItem(stack, at);
        }
        this.drinkIngredients.clear();
        this.ticks = 80;
        this.mixing = false;
        this.syncInventory();
    }

    public void retrieveResult(@Nullable Player at) {
        if (this.result.isEmpty()) {
            return;
        }
        this.dropItem(this.result, at);
        for (ItemStack ingredient : this.drinkIngredients) {
            ItemStack container = ingredient.getCraftingRemainder();
            if (container.isEmpty()) continue;
            this.dropItem(container, at);
        }
        this.drinkIngredients.clear();
        this.result = ItemStack.EMPTY;
        this.syncInventory();
    }

    public void finishMixing() {
        this.result = this.getResult();
        this.mixing = false;
        this.ticks = 0;
        this.syncInventory();
    }

    public boolean tryTransferToMixer(Level level, ItemStack itemStack, LivingEntity entity) {
        if (this.mixing || this.drinkIngredients.size() >= 3) {
            return false;
        }
        Holder<DrinkIngredient> ingredient = DrinkIngredient.findMatchingIngredient((HolderLookup.Provider)level.registryAccess(), itemStack);
        if (ingredient != null) {
            this.drinkIngredients.add(itemStack.consumeAndReturn(1, entity));
            this.syncInventory();
            return true;
        }
        return false;
    }

    public boolean isMixing() {
        return this.mixing;
    }

    @Override
    public boolean isActive() {
        return this.isMixing();
    }

    @Override
    public float getProgress(float partialTicks) {
        return ((float)this.ticks + partialTicks) / 80.0f;
    }

    @Override
    public Direction getDirection(BlockState state) {
        return (Direction)state.getValue(DrinkMixerBlock.FACING);
    }

    public void onDataPacket(Connection net, ValueInput input) {
        this.loadAdditional(input);
    }

    protected void syncInventory() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new ClientboundMixerInventoryPacket(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.setChanged();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    public ItemStack getResult() {
        return Drink.getResult((HolderLookup.Provider)this.level.registryAccess(), this.drinkIngredients);
    }
}

