/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.network.PacketDistributor;
import net.tropicraft.Constants;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.item.component.TropicraftDataComponents;
import net.tropicraft.core.common.network.message.ClientboundSifterInventoryPacket;
import net.tropicraft.core.common.network.message.ClientboundSifterStartPacket;

public class SifterBlockEntity
extends BlockEntity {
    private static final int SIFT_TIME = 80;
    private boolean isSifting;
    private int currentSiftTime = 80;
    private final RandomSource rand;
    public double yaw;
    public double yaw2 = 0.0;
    @Nonnull
    private ItemStack siftItem = ItemStack.EMPTY;

    public SifterBlockEntity(BlockEntityType<SifterBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.rand = RandomSource.create();
    }

    @Nonnull
    public ItemStack getSiftItem() {
        return this.siftItem;
    }

    public static void siftTick(Level level, BlockPos pos, BlockState state, SifterBlockEntity sifter) {
        sifter.tick();
    }

    private void tick() {
        if (this.currentSiftTime > 0 && this.isSifting) {
            --this.currentSiftTime;
        }
        if (this.level.isClientSide) {
            this.yaw2 = this.yaw % 360.0;
            this.yaw += 45.45454502105713;
        }
        if (this.isSifting && this.currentSiftTime <= 0) {
            this.stopSifting();
        }
    }

    public void dumpResults(BlockPos pos) {
        this.dumpBeachResults(pos);
        this.syncInventory();
    }

    private void dumpBeachResults(BlockPos pos) {
        int dumpCount = this.rand.nextInt(3) + 1;
        while (dumpCount > 0) {
            ItemStack stack;
            --dumpCount;
            if (this.rand.nextInt(10) == 0) {
                stack = this.getRareItem();
            } else if (this.rand.nextInt(10) < 3) {
                String name = this.rand.nextBoolean() ? Constants.LT17_NAMES[this.rand.nextInt(Constants.LT17_NAMES.length)] : Constants.LT18_NAMES[this.rand.nextInt(Constants.LT18_NAMES.length)];
                stack = new ItemStack((ItemLike)TropicraftItems.LOVE_TROPICS_SHELL.get());
                stack.set(TropicraftDataComponents.SHELL_NAME, (Object)name);
            } else {
                stack = this.getCommonItem();
            }
            this.spawnItem(stack, pos);
        }
    }

    private void spawnItem(ItemStack stack, BlockPos pos) {
        if (this.level.isClientSide) {
            return;
        }
        ItemEntity itemEntity = new ItemEntity(this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
        this.level.addFreshEntity((Entity)itemEntity);
    }

    private ItemStack getCommonItem() {
        HolderSet.Named tag = this.level.registryAccess().lookupOrThrow(Registries.ITEM).getOrThrow(TropicraftTags.Items.SHELLS);
        int shellIndex = this.rand.nextInt(tag.size() + 1) - 1;
        if (shellIndex < 0) {
            return this.getRareItem();
        }
        return new ItemStack((ItemLike)((Holder)tag.getRandomElement(this.rand).get()).value());
    }

    private ItemStack getRareItem() {
        return switch (this.rand.nextInt(12)) {
            case 1 -> new ItemStack((ItemLike)Items.GOLD_NUGGET, 1);
            case 2 -> new ItemStack((ItemLike)Items.BUCKET, 1);
            case 3 -> new ItemStack((ItemLike)Items.WOODEN_SHOVEL, 1);
            case 4 -> new ItemStack((ItemLike)Items.GLASS_BOTTLE, 1);
            case 5 -> new ItemStack((ItemLike)TropicraftItems.WHITE_PEARL.get(), 1);
            case 6 -> new ItemStack((ItemLike)TropicraftItems.BLACK_PEARL.get(), 1);
            case 7 -> new ItemStack((ItemLike)Items.STONE_SHOVEL, 1);
            default -> new ItemStack((ItemLike)TropicraftItems.RUBE_NAUTILUS.get());
        };
    }

    public void addItemToSifter(ItemStack stack) {
        this.siftItem = stack.copyWithCount(1);
        this.syncInventory();
    }

    public void startSifting() {
        this.isSifting = true;
        this.currentSiftTime = 80;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new ClientboundSifterStartPacket(this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void stopSifting() {
        double x = (double)this.worldPosition.getX() + this.level.random.nextDouble() * 1.4;
        double y = (double)this.worldPosition.getY() + this.level.random.nextDouble() * 1.4;
        double z = (double)this.worldPosition.getZ() + this.level.random.nextDouble() * 1.4;
        if (!this.level.isClientSide) {
            this.dumpResults(BlockPos.containing((double)x, (double)y, (double)z));
        }
        this.currentSiftTime = 80;
        this.isSifting = false;
        this.siftItem = ItemStack.EMPTY;
        this.syncInventory();
    }

    public void setSifting(boolean flag) {
        this.isSifting = flag;
    }

    public boolean isSifting() {
        return this.isSifting;
    }

    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.isSifting = input.getBooleanOr("isSifting", false);
        this.currentSiftTime = input.getIntOr("currentSiftTime", 0);
        this.siftItem = input.read("Item", ItemStack.CODEC).orElse(ItemStack.EMPTY);
    }

    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putBoolean("isSifting", this.isSifting);
        output.putInt("currentSiftTime", this.currentSiftTime);
        if (!this.siftItem.isEmpty()) {
            output.store("Item", ItemStack.CODEC, (Object)this.siftItem);
        }
    }

    public void onDataPacket(Connection net, ValueInput input) {
        this.loadAdditional(input);
    }

    protected void syncInventory() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new ClientboundSifterInventoryPacket(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    public void setSiftItem(ItemStack siftItem) {
        this.siftItem = siftItem.copyWithCount(1);
    }
}

