/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.command.debug;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;

public class MapBiomesCommand {
    private static final int SIZE = 4096;
    private static final int SIZE2 = 2048;
    private static final int SIZE8 = 512;
    private static final Object2IntOpenHashMap<ResourceLocation> COLORS = new Object2IntOpenHashMap();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mapbiomes").requires(s -> s.hasPermission(2))).executes(c -> MapBiomesCommand.execute((CommandSourceStack)c.getSource())));
    }

    private static int execute(CommandSourceStack source) {
        if (!source.getLevel().dimension().equals(TropicraftDimension.WORLD)) {
            source.sendFailure((Component)Component.literal((String)"Can't execute this in non-tropicraft world!"));
        }
        BufferedImage img = new BufferedImage(4096, 4096, 1);
        Registry biomes = source.getLevel().registryAccess().lookupOrThrow(Registries.BIOME);
        for (int x = -2048; x < 2048; ++x) {
            if (x % 512 == 0) {
                double progress = (double)(x + 2048) / 4096.0;
                source.sendSuccess(() -> Component.literal((String)(progress * 100.0 + "%")), false);
            }
            for (int z = -2048; z < 2048; ++z) {
                Biome biome = (Biome)source.getLevel().getUncachedNoiseBiome(x, 0, z).value();
                ResourceLocation name = biomes.getKey((Object)biome);
                img.setRGB(x + 2048, z + 2048, COLORS.getOrDefault((Object)name, 0xFFFFFF));
            }
        }
        Path p = Paths.get("biome_colors.png", new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
            source.sendSuccess(() -> Component.literal((String)"Mapped biome colors!"), false);
        }
        catch (IOException e) {
            source.sendFailure((Component)Component.literal((String)"Something went wrong, check the log!"));
            e.printStackTrace();
        }
        return 0;
    }

    static {
        COLORS.put((Object)TropicraftBiomes.TROPICS.location(), 8183411);
        COLORS.put((Object)TropicraftBiomes.RAINFOREST.location(), 4175157);
        COLORS.put((Object)TropicraftBiomes.OSA_RAINFOREST.location(), 5820749);
        COLORS.put((Object)TropicraftBiomes.BAMBOO_RAINFOREST.location(), 5751356);
        COLORS.put((Object)TropicraftBiomes.MANGROVES.location(), 4491059);
        COLORS.put((Object)TropicraftBiomes.OVERGROWN_MANGROVES.location(), 6129459);
        COLORS.put((Object)TropicraftBiomes.OCEAN.location(), 5226953);
        COLORS.put((Object)TropicraftBiomes.RIVER.location(), 5226953);
        COLORS.put((Object)TropicraftBiomes.KELP_FOREST.location(), 5228975);
        COLORS.put((Object)TropicraftBiomes.BEACH.location(), 15262615);
    }
}

