/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.datafix;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Set;
import net.minecraft.util.datafix.fixes.AbstractBlockPropertyFix;

public class TropicraftDataFixers {
    private static final Set<String> PERSISTENT_LEAVES = Set.of("tropicraft:mahogany_leaves", "tropicraft:palm_leaves", "tropicraft:kapok_leaves");

    public static void injectFixers(Builder builder) {
        Schema v4424 = builder.getSchema(4424, 0);
        builder.injectFixer((DataFix)new AbstractBlockPropertyFix(v4424, "TropicraftFixPersistentLeaves"){

            protected boolean shouldFix(String name) {
                return PERSISTENT_LEAVES.contains(name);
            }

            protected <T> Dynamic<T> fixProperties(String name, Dynamic<T> properties) {
                boolean newDecay = properties.get("new_decay").asBoolean(false);
                properties = properties.remove("new_decay");
                if (!newDecay) {
                    return properties.set("persistent", properties.createBoolean(true));
                }
                return properties;
            }
        });
    }

    public static interface Builder {
        public void injectFixer(DataFix var1);

        public Schema getSchema(int var1, int var2);
    }
}

