/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.block.BlockTropicraftSand;
import net.tropicraft.core.common.block.TikiTorchBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import org.slf4j.Logger;

public class TropicsPortalLinker {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Block PORTAL_WALL_BLOCK = Blocks.SANDSTONE;
    private static final Block PORTAL_BLOCK = (Block)TropicraftBlocks.PORTAL_WATER.get();
    private static final Block TELEPORTER_BLOCK = (Block)TropicraftBlocks.TELEPORT_WATER.get();
    private final ServerLevel world;

    public TropicsPortalLinker(ServerLevel world) {
        this.world = world;
    }

    @Nullable
    public PortalInfo findOrCreatePortal(Entity entity) {
        long startTime = System.currentTimeMillis();
        PortalInfo portalInfo = this.findExistingPortal(entity);
        if (portalInfo == null) {
            this.makePortal(entity);
            portalInfo = this.findExistingPortal(entity);
        }
        long finishTime = System.currentTimeMillis();
        LOGGER.debug("It took {} seconds for TeleporterTropics.placeInPortal to complete", (Object)Float.valueOf((float)(finishTime - startTime) / 1000.0f));
        return portalInfo;
    }

    @Nullable
    private PortalInfo findExistingPortal(Entity entity) {
        int searchArea = 148;
        double closestPortalDistance = -1.0;
        int foundX = 0;
        int foundY = 0;
        int foundZ = 0;
        int entityX = Mth.floor((float)entity.getOnPos().getX());
        int entityZ = Mth.floor((float)entity.getOnPos().getZ());
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = entityX - searchArea; x <= entityX + searchArea; ++x) {
            double distX = (double)x + 0.5 - (double)entity.getOnPos().getX();
            for (int z = entityZ - searchArea; z <= entityZ + searchArea; ++z) {
                double distZ = (double)z + 0.5 - (double)entity.getOnPos().getZ();
                LevelChunk chunk = this.world.getChunk(SectionPos.blockToSectionCoord((int)x), SectionPos.blockToSectionCoord((int)z));
                for (int y = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, x, z); y >= chunk.getMinY(); --y) {
                    mutablePos.set(x, y, z);
                    if (!chunk.getBlockState((BlockPos)mutablePos).is(PORTAL_BLOCK)) continue;
                    mutablePos.move(Direction.DOWN);
                    while (chunk.getBlockState((BlockPos)mutablePos).is(PORTAL_BLOCK)) {
                        --y;
                        mutablePos.move(Direction.DOWN);
                    }
                    double distY = (double)y + 0.5 - (double)mutablePos.getY();
                    double distance = Mth.lengthSquared((double)distX, (double)distY, (double)distZ);
                    if (!(closestPortalDistance < 0.0) && !(distance < closestPortalDistance)) continue;
                    closestPortalDistance = distance;
                    foundX = x;
                    foundY = y;
                    foundZ = z;
                }
            }
        }
        if (closestPortalDistance >= 0.0) {
            double newLocX = (double)foundX + 0.5;
            double newLocY = (double)foundY + 0.5;
            double newLocZ = (double)foundZ + 0.5;
            BlockPos pos = new BlockPos(foundX, foundY, foundZ);
            if (this.world.getBlockState(pos.west()).is(PORTAL_BLOCK)) {
                newLocX -= 0.5;
            }
            if (this.world.getBlockState(pos.east()).is(PORTAL_BLOCK)) {
                newLocX += 0.5;
            }
            if (this.world.getBlockState(pos.north()).is(PORTAL_BLOCK)) {
                newLocZ -= 0.5;
            }
            if (this.world.getBlockState(pos.south()).is(PORTAL_BLOCK)) {
                newLocZ += 0.5;
            }
            return new PortalInfo(new Vec3(newLocX, newLocY + 2.0, newLocZ), entity.getYRot(), entity.getXRot());
        }
        return null;
    }

    private boolean makePortal(Entity entity) {
        int searchArea = 16;
        double closestSpot = -1.0;
        int entityX = Mth.floor((double)entity.getX());
        int entityY = Mth.floor((double)entity.getY());
        int entityZ = Mth.floor((double)entity.getZ());
        int foundX = entityX;
        int foundY = entityY;
        int foundZ = entityZ;
        for (int x = entityX - searchArea; x <= entityX + searchArea; ++x) {
            double distX = (double)x + 0.5 - entity.getX();
            block1: for (int z = entityZ - searchArea; z <= entityZ + searchArea; ++z) {
                double distZ = (double)z + 0.5 - entity.getZ();
                int y = this.world.getMaxY();
                BlockPos pos = new BlockPos(x, y, z);
                while (y >= 62 && (this.world.getBlockState(pos).is(Blocks.AIR) || !this.getValidBuildBlocks().contains(this.world.getBlockState(pos)))) {
                    y = pos.getY();
                    pos = pos.below();
                }
                if (y > 83 || y < 63) continue;
                BlockPos tryPos = new BlockPos(x, y, z);
                if (!this.getValidBuildBlocks().contains(this.world.getBlockState(tryPos))) continue;
                for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                    for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                        int otherY = this.world.getMaxY();
                        BlockPos pos1 = new BlockPos(x + xOffset, otherY, z + zOffset);
                        BlockPos.MutableBlockPos pos2 = tryPos.mutable();
                        while (otherY >= 63 && (this.world.getBlockState(pos1).is(Blocks.AIR) || !this.world.getBlockState((BlockPos)pos2).isAir())) {
                            otherY = pos1.getY();
                            pos1 = pos1.below();
                        }
                        if (Math.abs(y - otherY) >= 3) continue block1;
                    }
                }
                double distY = (double)y + 0.5 - entity.getY();
                double distance = distX * distX + distY * distY + distZ * distZ;
                if (!(closestSpot < 0.0) && !(distance < closestSpot)) continue;
                closestSpot = distance;
                foundX = x;
                foundY = y;
                foundZ = z;
            }
        }
        int worldSpawnX = Mth.floor((float)foundX);
        int worldSpawnZ = Mth.floor((float)foundZ);
        int worldSpawnY = this.getTerrainHeightAt(worldSpawnX, worldSpawnZ);
        int SEARCH_FOR_LAND_DISTANCE_MAX = 200;
        if (closestSpot < 0.0) {
            RandomSource r = RandomSource.create();
            foundX += r.nextInt(16) - 8;
            foundZ += r.nextInt(16) - 8;
            foundY = worldSpawnY - 2;
            boolean foundLand = false;
            block6: for (int dist = 1; !foundLand && dist < SEARCH_FOR_LAND_DISTANCE_MAX; ++dist) {
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BlockPos pos = new BlockPos(worldSpawnX, worldSpawnY, worldSpawnZ).relative(dir, 3 + dist);
                    BlockState state = this.world.getBlockState(pos);
                    if (!this.getValidBuildBlocks().contains(state)) continue;
                    foundLand = true;
                    BlockPos buildpos = new BlockPos(worldSpawnX, worldSpawnY + 1, worldSpawnZ).relative(dir, 3);
                    while (!buildpos.equals((Object)pos.above())) {
                        BlockState thatch = ((RotatedPillarBlock)TropicraftBlocks.THATCH_BUNDLE.get()).defaultBlockState();
                        this.world.setBlockAndUpdate(buildpos, thatch);
                        this.world.setBlockAndUpdate(buildpos.relative(dir.getClockWise()), thatch);
                        this.world.setBlockAndUpdate(buildpos.relative(dir.getCounterClockWise()), thatch);
                        buildpos = buildpos.relative(dir);
                    }
                    BlockPos stairPosMid = new BlockPos(pos.getX(), worldSpawnY + 1, worldSpawnZ);
                    this.placeStairs(stairPosMid, dir.getOpposite());
                    this.generateThatchBorder(worldSpawnX, worldSpawnY + 1, worldSpawnZ);
                    continue block6;
                }
            }
        }
        this.buildTeleporterAt(worldSpawnX, worldSpawnY + 1, worldSpawnZ);
        return true;
    }

    private void placeStairs(BlockPos pos, Direction dir) {
        if (dir == Direction.EAST || dir == Direction.WEST) {
            BlockPos stairPosLeft = pos.offset(0, 0, -1);
            BlockPos stairPosMid = pos;
            BlockPos stairPosRight = pos.offset(0, 0, 1);
            BlockState thatchStairState = (BlockState)((StairBlock)TropicraftBlocks.THATCH_STAIRS.get()).defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)dir);
            this.world.setBlockAndUpdate(stairPosLeft, thatchStairState);
            this.world.setBlockAndUpdate(stairPosMid, thatchStairState);
            this.world.setBlockAndUpdate(stairPosRight, thatchStairState);
        } else if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            BlockPos stairPosLeft = pos.offset(-1, 0, 0);
            BlockPos stairPosMid = pos;
            BlockPos stairPosRight = pos.offset(1, 0, 0);
            BlockState thatchStairState = (BlockState)((StairBlock)TropicraftBlocks.THATCH_STAIRS.get()).defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)dir);
            this.world.setBlockAndUpdate(stairPosLeft, thatchStairState);
            this.world.setBlockAndUpdate(stairPosMid, thatchStairState);
            this.world.setBlockAndUpdate(stairPosRight, thatchStairState);
        }
    }

    private void generateThatchBorder(int x, int y, int z) {
        for (int zOffset = -4; zOffset <= 4; ++zOffset) {
            for (int xOffset = -4; xOffset <= 4; ++xOffset) {
                boolean isWall;
                boolean bl = isWall = xOffset < -2 || xOffset > 2 || zOffset < -2 || zOffset > 2;
                if (!isWall) continue;
                BlockPos thatchPos = new BlockPos(x + xOffset, y, z + zOffset);
                this.world.setBlockAndUpdate(thatchPos, ((RotatedPillarBlock)TropicraftBlocks.THATCH_BUNDLE.get()).defaultBlockState());
            }
        }
    }

    private int getTerrainHeightAt(int x, int z) {
        int worldSpawnY;
        LevelChunk chunk2 = this.world.getChunk(x >> 4, z >> 4);
        for (int y = worldSpawnY = chunk2.getHeight(Heightmap.Types.WORLD_SURFACE, x & 0xF, z & 0xF); y > 0; --y) {
            BlockState state = this.world.getBlockState(new BlockPos(x, y, z));
            if (!state.is(BlockTags.DIRT) && !state.is(BlockTags.SAND) && !state.is(Blocks.WATER) && !state.is(BlockTags.BASE_STONE_OVERWORLD)) continue;
            return y;
        }
        return 0;
    }

    private void buildTeleporterAt(int x, int y, int z) {
        y = Math.max(y, 9);
        for (int yOffset = 4; yOffset >= -7; --yOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                    boolean isCorner;
                    int blockX = x + xOffset;
                    int blockY = y + yOffset;
                    int blockZ = z + zOffset;
                    BlockPos pos = new BlockPos(blockX, blockY, blockZ);
                    if (yOffset == -7) {
                        this.world.setBlockAndUpdate(pos, PORTAL_WALL_BLOCK.defaultBlockState());
                    } else if (yOffset > 0) {
                        this.world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    } else {
                        boolean isWall;
                        boolean bl = isWall = xOffset == -2 || xOffset == 2 || zOffset == -2 || zOffset == 2;
                        if (isWall) {
                            this.world.setBlockAndUpdate(pos, PORTAL_WALL_BLOCK.defaultBlockState());
                        } else {
                            boolean isTeleportBlock;
                            boolean bl2 = isTeleportBlock = yOffset <= -5;
                            if (isTeleportBlock) {
                                this.world.setBlockAndUpdate(pos, TELEPORTER_BLOCK.defaultBlockState());
                            } else {
                                this.world.setBlockAndUpdate(pos, PORTAL_BLOCK.defaultBlockState());
                            }
                        }
                    }
                    boolean bl = isCorner = !(xOffset != -2 && xOffset != 2 || zOffset != -2 && zOffset != 2);
                    if (yOffset != 0 || !isCorner) continue;
                    this.world.setBlock(pos.above(), (BlockState)((TikiTorchBlock)((Object)TropicraftBlocks.TIKI_TORCH.get())).defaultBlockState().setValue(TikiTorchBlock.SECTION, (Comparable)((Object)TikiTorchBlock.TorchSection.LOWER)), 3);
                    this.world.setBlock(pos.above(2), (BlockState)((TikiTorchBlock)((Object)TropicraftBlocks.TIKI_TORCH.get())).defaultBlockState().setValue(TikiTorchBlock.SECTION, (Comparable)((Object)TikiTorchBlock.TorchSection.MIDDLE)), 3);
                    this.world.setBlock(pos.above(3), (BlockState)((TikiTorchBlock)((Object)TropicraftBlocks.TIKI_TORCH.get())).defaultBlockState().setValue(TikiTorchBlock.SECTION, (Comparable)((Object)TikiTorchBlock.TorchSection.UPPER)), 3);
                }
            }
        }
    }

    private List<BlockState> getValidBuildBlocks() {
        return Arrays.asList(Blocks.SAND.defaultBlockState(), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), ((BlockTropicraftSand)((Object)TropicraftBlocks.PURIFIED_SAND.get())).defaultBlockState());
    }

    public record PortalInfo(Vec3 position, float yRot, float xRot) {
    }
}

