/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;

public class TropicraftBiomeBuilder {
    private static final MultiNoiseBiomeSourceParameterList.Preset PRESET = TropicraftBiomeBuilder.registerMultiNoisePreset(TropicraftDimension.ID, new MultiNoiseBiomeSourceParameterList.Preset.SourceProvider(){

        public <T> Climate.ParameterList<T> apply(Function<ResourceKey<Biome>, T> function) {
            ImmutableList.Builder points = ImmutableList.builder();
            new TropicraftBiomeBuilder().addBiomes((point, key) -> points.add((Object)Pair.of((Object)point, function.apply((ResourceKey<Biome>)key))));
            return new Climate.ParameterList((List)points.build());
        }
    });
    public static final ResourceKey<MultiNoiseBiomeSourceParameterList> PARAMETER_LIST = ResourceKey.create((ResourceKey)Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, (ResourceLocation)TropicraftDimension.ID);
    private final Climate.Parameter islandContinentalness = Climate.Parameter.span((float)-1.1f, (float)-0.92f);
    private final Climate.Parameter oceanContinentalness = Climate.Parameter.span((float)-0.92f, (float)-0.19f);
    private final Climate.Parameter landContinentalness = Climate.Parameter.span((float)-0.1f, (float)1.0f);
    private final Climate.Parameter coastContinentalness = Climate.Parameter.span((float)-0.19f, (float)-0.1f);
    private final Climate.Parameter nearInlandContinentalness = Climate.Parameter.span((float)-0.1f, (float)0.03f);
    private final Climate.Parameter midInlandContinentalness = Climate.Parameter.span((float)0.03f, (float)0.3f);
    private final Climate.Parameter farInlandContinentalness = Climate.Parameter.span((float)0.3f, (float)1.0f);
    private final Climate.Parameter fullRange = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    private final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.45f), Climate.Parameter.span((float)-0.45f, (float)-0.15f), Climate.Parameter.span((float)-0.15f, (float)0.2f), Climate.Parameter.span((float)0.2f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    private final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.35f), Climate.Parameter.span((float)-0.35f, (float)-0.1f), Climate.Parameter.span((float)-0.1f, (float)0.1f), Climate.Parameter.span((float)0.1f, (float)0.3f), Climate.Parameter.span((float)0.3f, (float)1.0f)};
    private final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.78f), Climate.Parameter.span((float)-0.78f, (float)-0.375f), Climate.Parameter.span((float)-0.375f, (float)-0.2225f), Climate.Parameter.span((float)-0.2225f, (float)0.05f), Climate.Parameter.span((float)0.05f, (float)0.45f), Climate.Parameter.span((float)0.45f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    private final Climate.Parameter wet = Climate.Parameter.span((Climate.Parameter)this.humidities[2], (Climate.Parameter)this.humidities[4]);
    private final Climate.Parameter lessWet = Climate.Parameter.span((Climate.Parameter)this.humidities[0], (Climate.Parameter)this.humidities[1]);
    private final Climate.Parameter mostWet = Climate.Parameter.span((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]);

    private static MultiNoiseBiomeSourceParameterList.Preset registerMultiNoisePreset(ResourceLocation id, MultiNoiseBiomeSourceParameterList.Preset.SourceProvider sourceProvider) {
        MultiNoiseBiomeSourceParameterList.Preset preset = new MultiNoiseBiomeSourceParameterList.Preset(id, sourceProvider);
        MultiNoiseBiomeSourceParameterList.Preset.BY_NAME = Util.copyAndPut((Map)MultiNoiseBiomeSourceParameterList.Preset.BY_NAME, (Object)id, (Object)preset);
        return preset;
    }

    public static void bootstrap(BootstrapContext<MultiNoiseBiomeSourceParameterList> context) {
        context.register(PARAMETER_LIST, (Object)new MultiNoiseBiomeSourceParameterList(PRESET, context.lookup(Registries.BIOME)));
    }

    public void addBiomes(BiConsumer<Climate.ParameterPoint, ResourceKey<Biome>> consumer) {
        this.addInlandBiomes(consumer);
        this.addSurfaceBiome(consumer, this.fullRange, Climate.Parameter.span((Climate.Parameter)this.lessWet, (Climate.Parameter)this.humidities[2]), this.oceanContinentalness, this.fullRange, this.fullRange, 0.0f, TropicraftBiomes.OCEAN);
        this.addSurfaceBiome(consumer, this.fullRange, this.mostWet, this.oceanContinentalness, this.fullRange, this.fullRange, 0.0f, TropicraftBiomes.KELP_FOREST);
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, this.islandContinentalness, this.fullRange, this.fullRange, 0.0f, TropicraftBiomes.RAINFOREST);
    }

    private void addInlandBiomes(BiConsumer<Climate.ParameterPoint, ResourceKey<Biome>> consumer) {
        this.addMidSlice(consumer, Climate.Parameter.span((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(consumer, Climate.Parameter.span((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(consumer, Climate.Parameter.span((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(consumer, Climate.Parameter.span((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(consumer, Climate.Parameter.span((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(consumer, Climate.Parameter.span((float)-0.26666668f, (float)-0.05f));
        this.addValleys(consumer, Climate.Parameter.span((float)-0.05f, (float)0.05f));
        this.addLowSlice(consumer, Climate.Parameter.span((float)0.05f, (float)0.26666668f));
        this.addMidSlice(consumer, Climate.Parameter.span((float)0.26666668f, (float)0.4f));
        this.addHighSlice(consumer, Climate.Parameter.span((float)0.4f, (float)0.56666666f));
        this.addPeaks(consumer, Climate.Parameter.span((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(consumer, Climate.Parameter.span((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(consumer, Climate.Parameter.span((float)0.93333334f, (float)1.0f));
    }

    private void addValleys(BiConsumer<Climate.ParameterPoint, ResourceKey<Biome>> consumer, Climate.Parameter weirdness) {
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, TropicraftBiomes.RIVER);
        this.addSurfaceBiome(consumer, this.fullRange, Climate.Parameter.span((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]), this.landContinentalness, this.erosions[6], weirdness, 0.0f, TropicraftBiomes.MANGROVES);
        this.addSurfaceBiome(consumer, this.fullRange, Climate.Parameter.span((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]), this.landContinentalness, this.erosions[4], weirdness, 0.0f, TropicraftBiomes.MANGROVES);
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, TropicraftBiomes.TROPICS);
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[5], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, TropicraftBiomes.TROPICS);
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, TropicraftBiomes.RIVER);
        this.addSurfaceBiome(consumer, this.fullRange, this.lessWet, this.farInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, TropicraftBiomes.TROPICS);
    }

    private void addLowSlice(BiConsumer<Climate.ParameterPoint, ResourceKey<Biome>> consumer, Climate.Parameter weirdness) {
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[4], (Climate.Parameter)this.erosions[6]), weirdness, 0.0f, TropicraftBiomes.BEACH);
        if (weirdness.max() < 0L) {
            this.addSurfaceBiome(consumer, this.fullRange, Climate.Parameter.span((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]), this.landContinentalness, this.erosions[6], weirdness, 0.0f, TropicraftBiomes.OVERGROWN_MANGROVES);
            this.addSurfaceBiome(consumer, this.fullRange, Climate.Parameter.span((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]), this.landContinentalness, this.erosions[4], weirdness, 0.0f, TropicraftBiomes.OVERGROWN_MANGROVES);
        } else {
            this.addSurfaceBiome(consumer, this.fullRange, Climate.Parameter.span((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]), this.landContinentalness, this.erosions[6], weirdness, 0.0f, TropicraftBiomes.MANGROVES);
            this.addSurfaceBiome(consumer, this.fullRange, Climate.Parameter.span((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]), this.landContinentalness, this.erosions[4], weirdness, 0.0f, TropicraftBiomes.MANGROVES);
        }
        this.addSurfaceBiome(consumer, this.fullRange, this.humidities[4], this.landContinentalness, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        this.addSurfaceBiome(consumer, this.fullRange, Climate.Parameter.span((Climate.Parameter)this.humidities[0], (Climate.Parameter)this.humidities[3]), this.landContinentalness, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        if (weirdness.max() < 0L) {
            this.addSurfaceBiome(consumer, this.fullRange, this.wet, this.landContinentalness, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.OSA_RAINFOREST);
        } else {
            this.addSurfaceBiome(consumer, this.fullRange, this.wet, this.landContinentalness, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        }
        this.addSurfaceBiome(consumer, this.fullRange, this.lessWet, this.landContinentalness, this.erosions[2], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        if (weirdness.max() < 0L) {
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, this.landContinentalness, this.erosions[1], weirdness, 0.0f, TropicraftBiomes.OSA_RAINFOREST);
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, this.landContinentalness, this.erosions[0], weirdness, 0.0f, TropicraftBiomes.OSA_RAINFOREST);
        } else {
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, this.landContinentalness, this.erosions[1], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, this.landContinentalness, this.erosions[0], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        }
    }

    private void addMidSlice(BiConsumer<Climate.ParameterPoint, ResourceKey<Biome>> consumer, Climate.Parameter weirdness) {
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[4], (Climate.Parameter)this.erosions[6]), weirdness, 0.0f, TropicraftBiomes.BEACH);
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, this.landContinentalness, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        this.addSurfaceBiome(consumer, this.fullRange, this.wet, this.landContinentalness, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        this.addSurfaceBiome(consumer, this.fullRange, this.lessWet, this.landContinentalness, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, this.landContinentalness, this.erosions[2], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, this.landContinentalness, this.erosions[1], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, this.landContinentalness, this.erosions[0], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
    }

    private void addHighSlice(BiConsumer<Climate.ParameterPoint, ResourceKey<Biome>> consumer, Climate.Parameter weirdness) {
        Climate.Parameter coastInwards = Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness);
        Climate.Parameter midInwards = Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness);
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, coastInwards, this.erosions[6], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        if (weirdness.max() < 0L) {
            this.addSurfaceBiome(consumer, this.fullRange, this.wet, coastInwards, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        } else {
            this.addSurfaceBiome(consumer, this.fullRange, this.wet, coastInwards, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
        }
        this.addSurfaceBiome(consumer, this.fullRange, this.lessWet, coastInwards, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        this.addSurfaceBiome(consumer, this.fullRange, this.wet, coastInwards, this.erosions[4], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        this.addSurfaceBiome(consumer, this.fullRange, this.lessWet, coastInwards, this.erosions[4], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        if (weirdness.max() < 0L) {
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, midInwards, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, midInwards, this.erosions[2], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, midInwards, this.erosions[1], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, midInwards, this.erosions[0], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        } else {
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, midInwards, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, midInwards, this.erosions[2], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, midInwards, this.erosions[1], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, midInwards, this.erosions[0], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
        }
    }

    private void addPeaks(BiConsumer<Climate.ParameterPoint, ResourceKey<Biome>> consumer, Climate.Parameter weirdness) {
        Climate.Parameter coastInwards = Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness);
        Climate.Parameter midInwards = Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness);
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, coastInwards, this.erosions[6], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        if (weirdness.max() < 0L) {
            this.addSurfaceBiome(consumer, this.fullRange, this.wet, coastInwards, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        } else {
            this.addSurfaceBiome(consumer, this.fullRange, this.wet, coastInwards, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
        }
        this.addSurfaceBiome(consumer, this.fullRange, this.lessWet, coastInwards, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, coastInwards, this.erosions[4], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        if (weirdness.max() < 0L) {
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, midInwards, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, midInwards, this.erosions[2], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        } else {
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, midInwards, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
            this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, midInwards, this.erosions[2], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
        }
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, TropicraftBiomes.TROPICAL_PEAKS);
        this.addSurfaceBiome(consumer, this.fullRange, this.fullRange, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, TropicraftBiomes.TROPICAL_PEAKS);
    }

    private void addSurfaceBiome(BiConsumer<Climate.ParameterPoint, ResourceKey<Biome>> consumer, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        consumer.accept(Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)weirdness, (float)offset), biome);
        consumer.accept(Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)1.0f), (Climate.Parameter)weirdness, (float)offset), biome);
    }

    public String getDebugStringForContinentalness(double continentalness) {
        double quantized = Climate.quantizeCoord((float)((float)continentalness));
        if (quantized < (double)this.islandContinentalness.max()) {
            return "Islands";
        }
        if (quantized < (double)this.oceanContinentalness.max()) {
            return "Ocean";
        }
        if (quantized < (double)this.coastContinentalness.max()) {
            return "Coast";
        }
        if (quantized < (double)this.nearInlandContinentalness.max()) {
            return "Near inland";
        }
        if (quantized < (double)this.midInlandContinentalness.max()) {
            return "Mid inland";
        }
        return "Far inland";
    }

    public String getDebugStringForErosion(double erosion) {
        return TropicraftBiomeBuilder.getDebugStringForNoiseValue(erosion, this.erosions);
    }

    public String getDebugStringForTemperature(double temperature) {
        return TropicraftBiomeBuilder.getDebugStringForNoiseValue(temperature, this.temperatures);
    }

    public String getDebugStringForHumidity(double humidity) {
        return TropicraftBiomeBuilder.getDebugStringForNoiseValue(humidity, this.humidities);
    }

    private static String getDebugStringForNoiseValue(double value, Climate.Parameter[] parameters) {
        double quantizedCoord = Climate.quantizeCoord((float)((float)value));
        for (int i = 0; i < parameters.length; ++i) {
            if (!(quantizedCoord < (double)parameters[i].max())) continue;
            return String.valueOf(i);
        }
        return "?";
    }
}

