/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.carver;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.TrapezoidFloat;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CanyonWorldCarver;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverDebugSettings;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveWorldCarver;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.heightproviders.BiasedToBottomHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.dimension.carver.TropicraftCarvers;

public final class TropicraftConfiguredCarvers {
    public static final ResourceKey<ConfiguredWorldCarver<?>> CAVE = TropicraftConfiguredCarvers.createKey("cave");
    public static final ResourceKey<ConfiguredWorldCarver<?>> CANYON = TropicraftConfiguredCarvers.createKey("canyon");

    public static void bootstrap(BootstrapContext<ConfiguredWorldCarver<?>> context) {
        HolderGetter blocks = context.lookup(Registries.BLOCK);
        context.register(CAVE, (Object)((CaveWorldCarver)TropicraftCarvers.CAVE.get()).configured((CarverConfiguration)new CaveCarverConfiguration(0.25f, (HeightProvider)BiasedToBottomHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)240), (int)8), (FloatProvider)ConstantFloat.of((float)0.5f), VerticalAnchor.aboveBottom((int)10), (HolderSet)blocks.getOrThrow(TropicraftTags.Blocks.CARVER_REPLACEABLES), (FloatProvider)ConstantFloat.of((float)1.0f), (FloatProvider)ConstantFloat.of((float)1.0f), (FloatProvider)ConstantFloat.of((float)-0.7f))));
        context.register(CANYON, (Object)((CanyonWorldCarver)TropicraftCarvers.CANYON.get()).configured((CarverConfiguration)new CanyonCarverConfiguration(0.02f, (HeightProvider)BiasedToBottomHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)20), (VerticalAnchor)VerticalAnchor.absolute((int)106), (int)8), (FloatProvider)ConstantFloat.of((float)3.0f), VerticalAnchor.aboveBottom((int)10), CarverDebugSettings.of((boolean)false, (BlockState)Blocks.WARPED_BUTTON.defaultBlockState()), (HolderSet)blocks.getOrThrow(TropicraftTags.Blocks.CARVER_REPLACEABLES), (FloatProvider)UniformFloat.of((float)-0.125f, (float)0.125f), new CanyonCarverConfiguration.CanyonShapeConfiguration((FloatProvider)UniformFloat.of((float)0.75f, (float)1.0f), (FloatProvider)TrapezoidFloat.of((float)0.0f, (float)6.0f, (float)2.0f), 3, (FloatProvider)UniformFloat.of((float)0.75f, (float)1.0f), 1.0f, 0.0f))));
    }

    public static void addLand(BiomeGenerationSettings.Builder generation) {
        generation.addCarver(CAVE);
        generation.addCarver(CANYON);
    }

    private static ResourceKey<ConfiguredWorldCarver<?>> createKey(String name) {
        return Tropicraft.resourceKey(Registries.CONFIGURED_CARVER, name);
    }
}

