/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.tropicraft.core.common.dimension.feature.SimpleTreeFeatureConfig;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftLeavesFixer;

public class SingleUndergrowthFeature
extends Feature<SimpleTreeFeatureConfig> {
    private static final int LARGE_BUSH_CHANCE = 4;

    public SingleUndergrowthFeature(Codec<SimpleTreeFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SimpleTreeFeatureConfig> context) {
        int size;
        WorldGenLevel level = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        SimpleTreeFeatureConfig config = (SimpleTreeFeatureConfig)context.config();
        int n = size = rand.nextInt(4) == 0 ? 3 : 2;
        if (!this.isValidPosition((LevelSimulatedReader)level, pos)) {
            return false;
        }
        if (TropicraftFeatureUtil.goesBeyondWorldSize(level, pos.getY(), size)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isSoil((LevelAccessor)level, pos.below())) {
            return false;
        }
        WorldgenRandom wrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(level.getSeed()));
        double[] dArray = new double[]{1.0};
        NormalNoise noise = NormalNoise.create((RandomSource)wrandom, (int)-7, (double[])dArray);
        if (Math.abs(noise.getValue((double)pos.getX(), 0.0, (double)pos.getZ())) < 0.03) {
            return false;
        }
        level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 3);
        ObjectOpenHashSet leaves = new ObjectOpenHashSet();
        BlockState leavesState = config.leaves().get();
        int count = 0;
        if (this.isValidPosition((LevelSimulatedReader)level, pos) && pos.getY() < level.getMaxY()) {
            for (int y = pos.getY(); y < pos.getY() + size; ++y) {
                int bushWidth = size - (y - pos.getY());
                for (int x = pos.getX() - bushWidth; x < pos.getX() + bushWidth; ++x) {
                    int xVariance = x - pos.getX();
                    for (int z = pos.getZ() - bushWidth; z < pos.getZ() + bushWidth; ++z) {
                        int zVariance = z - pos.getZ();
                        BlockPos newPos = new BlockPos(x, y, z);
                        if (Math.abs(xVariance) == bushWidth && Math.abs(zVariance) == bushWidth && rand.nextInt(2) == 0 || !this.isValidPosition((LevelSimulatedReader)level, newPos)) continue;
                        this.setBlock((LevelWriter)level, newPos, leavesState);
                        leaves.add(newPos);
                    }
                }
            }
            ++count;
        }
        this.setBlock((LevelWriter)level, pos, config.log().get());
        return count > 0 && TropicraftLeavesFixer.updateLeaves((LevelAccessor)level, Set.of(pos), (Set<BlockPos>)leaves, leavesState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValidPosition(LevelSimulatedReader level, BlockPos pos) {
        if (!TreeFeature.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)pos)) return false;
        if (level.isStateAtPosition(pos, arg_0 -> ((BlockState)Blocks.CAVE_AIR.defaultBlockState()).equals(arg_0))) return false;
        return true;
    }
}

