/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomBooleanFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.registries.DeferredHolder;

public class TropicraftFeatureUtil {
    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder.Reference<ConfiguredFeature<?, ?>> register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, DeferredHolder<Feature<?>, F> feature, FC config) {
        return context.register(key, (Object)new ConfiguredFeature((Feature)feature.get(), config));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder.Reference<ConfiguredFeature<?, ?>> register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
        return context.register(key, (Object)new ConfiguredFeature(feature, config));
    }

    public static <F extends Feature<NoneFeatureConfiguration>> Holder.Reference<ConfiguredFeature<?, ?>> register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, DeferredHolder<Feature<?>, F> feature) {
        return context.register(key, (Object)new ConfiguredFeature((Feature)feature.get(), (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE));
    }

    public static Holder.Reference<ConfiguredFeature<?, ?>> registerRandom(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, List<Holder<PlacedFeature>> choices) {
        return context.register(key, TropicraftFeatureUtil.randomFeature(choices));
    }

    public static ConfiguredFeature<?, ?> randomFeature(List<Holder<PlacedFeature>> choices) {
        if (choices.size() == 2) {
            Holder<PlacedFeature> left = choices.get(0);
            Holder<PlacedFeature> right = choices.get(1);
            return new ConfiguredFeature(Feature.RANDOM_BOOLEAN_SELECTOR, (FeatureConfiguration)new RandomBooleanFeatureConfiguration(left, right));
        }
        return new ConfiguredFeature(Feature.SIMPLE_RANDOM_SELECTOR, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct(choices)));
    }

    public static Holder.Reference<ConfiguredFeature<?, ?>> registerRandom(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, List<Pair<ResourceKey<PlacedFeature>, Float>> choices, ResourceKey<PlacedFeature> defaultFeature) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        return TropicraftFeatureUtil.registerRandomPlaced(context, key, choices.stream().map(pair -> {
            Holder.Reference holder = placedFeatures.getOrThrow((ResourceKey)pair.getFirst());
            return new WeightedPlacedFeature((Holder)holder, ((Float)pair.getSecond()).floatValue());
        }).toList(), defaultFeature);
    }

    public static Holder.Reference<ConfiguredFeature<?, ?>> registerRandomPlaced(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, List<WeightedPlacedFeature> choices, ResourceKey<PlacedFeature> defaultFeatureKey) {
        Holder.Reference defaultFeature = context.lookup(Registries.PLACED_FEATURE).getOrThrow(defaultFeatureKey);
        return TropicraftFeatureUtil.register(context, key, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(choices, (Holder)defaultFeature));
    }

    @SafeVarargs
    public static Holder.Reference<ConfiguredFeature<?, ?>> registerRandom(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, ResourceKey<ConfiguredFeature<?, ?>> ... choiceKeys) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        return TropicraftFeatureUtil.registerRandom(context, key, Arrays.stream(choiceKeys).map(k -> PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(k), (PlacementModifier[])new PlacementModifier[0])).toList());
    }

    @SafeVarargs
    public static Holder.Reference<ConfiguredFeature<?, ?>> registerRandomPlaced(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, ResourceKey<PlacedFeature> ... choices) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        return TropicraftFeatureUtil.registerRandom(context, key, Arrays.stream(choices).map(arg_0 -> ((HolderGetter)placedFeatures).getOrThrow(arg_0)).collect(Collectors.toList()));
    }

    public static RandomPatchConfiguration randomPatch(Supplier<? extends Block> block) {
        return TropicraftFeatureUtil.randomPatch((BlockStateProvider)BlockStateProvider.simple((Block)block.get()));
    }

    public static RandomPatchConfiguration randomPatch(BlockStateProvider blockStateProvider) {
        return FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(blockStateProvider));
    }

    public static OreConfiguration ore(int blobSize, Supplier<? extends Block> block) {
        TagMatchTest stoneOreReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        return new OreConfiguration(List.of(OreConfiguration.target((RuleTest)stoneOreReplaceables, (BlockState)block.get().defaultBlockState())), blobSize);
    }

    public static BlockStateProvider stateProvider(Supplier<? extends Block> block) {
        return BlockStateProvider.simple((Block)block.get());
    }

    public static boolean goesBeyondWorldSize(WorldGenLevel world, int y, int height) {
        return y < world.getMinY() + 1 || y + height > world.getMaxY();
    }

    public static boolean isBBAvailable(WorldGenLevel world, BlockPos pos, int height) {
        for (int y = 0; y <= 1 + height; ++y) {
            BlockPos checkPos = pos.above(y);
            int size = 1;
            if (checkPos.getY() < world.getMinY() || checkPos.getY() > world.getMaxY()) {
                return false;
            }
            if (y == 0) {
                size = 0;
            }
            if (y >= 1 + height - 2) {
                size = 2;
            }
            if (!BlockPos.betweenClosedStream((BlockPos)checkPos.offset(-size, 0, -size), (BlockPos)checkPos.offset(size, 0, size)).anyMatch(p -> !TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)p))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSoil(LevelAccessor level, BlockPos pos) {
        return level.getBlockState(pos).is(BlockTags.DIRT);
    }
}

