/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.tropicraft.core.common.dimension.feature.CoffeePlantFeature;
import net.tropicraft.core.common.dimension.feature.EIHFeature;
import net.tropicraft.core.common.dimension.feature.HugePlantFeature;
import net.tropicraft.core.common.dimension.feature.ReedsFeature;
import net.tropicraft.core.common.dimension.feature.SeagrassFeature;
import net.tropicraft.core.common.dimension.feature.SimpleTreeFeatureConfig;
import net.tropicraft.core.common.dimension.feature.SingleUndergrowthFeature;
import net.tropicraft.core.common.dimension.feature.UndergroundSeaPickleFeature;
import net.tropicraft.core.common.dimension.feature.UndergrowthFeature;
import net.tropicraft.core.common.dimension.feature.config.RainforestVinesConfig;
import net.tropicraft.core.common.dimension.feature.tree.CurvedPalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.LargePalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.NormalPalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.PalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.RainforestVinesFeature;
import net.tropicraft.core.common.dimension.feature.tree.TallRainforestTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.TualungFeature;
import net.tropicraft.core.common.dimension.feature.tree.UpTreeFeature;

public class TropicraftFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"tropicraft");
    public static final DeferredHolder<Feature<?>, PalmTreeFeature> NORMAL_PALM_TREE = TropicraftFeatures.register("normal_palm_tree", () -> new NormalPalmTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, PalmTreeFeature> CURVED_PALM_TREE = TropicraftFeatures.register("curved_palm_tree", () -> new CurvedPalmTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, PalmTreeFeature> LARGE_PALM_TREE = TropicraftFeatures.register("large_palm_tree", () -> new LargePalmTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, RainforestTreeFeature> UP_TREE = TropicraftFeatures.register("up_tree", () -> new UpTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, RainforestTreeFeature> SMALL_TUALUNG = TropicraftFeatures.register("small_tualung", () -> new TualungFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC, 16, 10));
    public static final DeferredHolder<Feature<?>, RainforestTreeFeature> LARGE_TUALUNG = TropicraftFeatures.register("large_tualung", () -> new TualungFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC, 24, 18));
    public static final DeferredHolder<Feature<?>, RainforestTreeFeature> TALL_TREE = TropicraftFeatures.register("tall_tree", () -> new TallRainforestTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, EIHFeature> EIH = TropicraftFeatures.register("eih", () -> new EIHFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, UndergrowthFeature> UNDERGROWTH = TropicraftFeatures.register("undergrowth", () -> new UndergrowthFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, SingleUndergrowthFeature> SINGLE_UNDERGROWTH = TropicraftFeatures.register("single_undergrowth", () -> new SingleUndergrowthFeature(SimpleTreeFeatureConfig.CODEC));
    public static final DeferredHolder<Feature<?>, RainforestVinesFeature> VINES = TropicraftFeatures.register("rainforest_vines", () -> new RainforestVinesFeature(RainforestVinesConfig.CODEC));
    public static final DeferredHolder<Feature<?>, UndergroundSeaPickleFeature> UNDERGROUND_SEA_PICKLE = TropicraftFeatures.register("underground_sea_pickle", () -> new UndergroundSeaPickleFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, CoffeePlantFeature> COFFEE_BUSH = TropicraftFeatures.register("coffee_bush", () -> new CoffeePlantFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, ReedsFeature> REEDS = TropicraftFeatures.register("reeds", () -> new ReedsFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, SeagrassFeature> SEAGRASS = TropicraftFeatures.register("seagrass", () -> new SeagrassFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, HugePlantFeature> HUGE_PLANT = TropicraftFeatures.register("huge_plant", () -> new HugePlantFeature((Codec<SimpleBlockConfiguration>)SimpleBlockConfiguration.CODEC));

    private static <T extends Feature<?>> DeferredHolder<Feature<?>, T> register(String name, Supplier<T> sup) {
        return FEATURES.register(name, sup);
    }
}

