/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;

public final class TropicraftMiscFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> MUD_DISK = TropicraftMiscFeatures.createKey("mud_disk");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EIH = TropicraftMiscFeatures.createKey("eih");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AZURITE = TropicraftMiscFeatures.createKey("azurite");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EUDIALYTE = TropicraftMiscFeatures.createKey("eudialyte");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ZIRCON = TropicraftMiscFeatures.createKey("zircon");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MANGANESE = TropicraftMiscFeatures.createKey("manganese");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHAKA = TropicraftMiscFeatures.createKey("shaka");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TropicraftFeatureUtil.register(context, MUD_DISK, Feature.DISK, new DiskConfiguration(RuleBasedBlockStateProvider.simple((Block)((Block)TropicraftBlocks.MUD.get())), BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.DIRT, Blocks.GRASS_BLOCK}), (IntProvider)UniformInt.of((int)2, (int)4), 2));
        TropicraftFeatureUtil.register(context, EIH, TropicraftFeatures.EIH, NoneFeatureConfiguration.INSTANCE);
        TropicraftFeatureUtil.register(context, AZURITE, Feature.ORE, TropicraftFeatureUtil.ore(8, TropicraftBlocks.AZURITE_ORE));
        TropicraftFeatureUtil.register(context, EUDIALYTE, Feature.ORE, TropicraftFeatureUtil.ore(12, TropicraftBlocks.EUDIALYTE_ORE));
        TropicraftFeatureUtil.register(context, ZIRCON, Feature.ORE, TropicraftFeatureUtil.ore(14, TropicraftBlocks.ZIRCON_ORE));
        TropicraftFeatureUtil.register(context, MANGANESE, Feature.ORE, TropicraftFeatureUtil.ore(10, TropicraftBlocks.MANGANESE_ORE));
        TropicraftFeatureUtil.register(context, SHAKA, Feature.ORE, TropicraftFeatureUtil.ore(8, TropicraftBlocks.SHAKA_ORE));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return Tropicraft.resourceKey(Registries.CONFIGURED_FEATURE, name);
    }
}

