/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.dimension.feature.TropicraftMiscFeatures;
import net.tropicraft.core.common.dimension.feature.TropicraftPlacementUtil;

public final class TropicraftMiscPlacements {
    public static final ResourceKey<PlacedFeature> MUD_DISK = TropicraftMiscPlacements.createKey("mud_disk");
    public static final ResourceKey<PlacedFeature> EIH = TropicraftMiscPlacements.createKey("eih");
    public static final ResourceKey<PlacedFeature> AZURITE = TropicraftMiscPlacements.createKey("azurite");
    public static final ResourceKey<PlacedFeature> EUDIALYTE = TropicraftMiscPlacements.createKey("eudialyte");
    public static final ResourceKey<PlacedFeature> ZIRCON = TropicraftMiscPlacements.createKey("zircon");
    public static final ResourceKey<PlacedFeature> MANGANESE = TropicraftMiscPlacements.createKey("manganese");
    public static final ResourceKey<PlacedFeature> SHAKA = TropicraftMiscPlacements.createKey("shaka");

    public static void boostrap(BootstrapContext<PlacedFeature> context) {
        TropicraftPlacementUtil.register(context, MUD_DISK, TropicraftMiscFeatures.MUD_DISK, List.of(CountPlacement.of((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, EIH, TropicraftMiscFeatures.EIH, List.of(PlacementUtils.countExtra((int)0, (float)0.0025f, (int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, AZURITE, TropicraftMiscFeatures.AZURITE, TropicraftPlacementUtil.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-20), (VerticalAnchor)VerticalAnchor.belowTop((int)80))));
        TropicraftPlacementUtil.register(context, EUDIALYTE, TropicraftMiscFeatures.EUDIALYTE, TropicraftPlacementUtil.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-20), (VerticalAnchor)VerticalAnchor.belowTop((int)80))));
        TropicraftPlacementUtil.register(context, ZIRCON, TropicraftMiscFeatures.ZIRCON, TropicraftPlacementUtil.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-20), (VerticalAnchor)VerticalAnchor.belowTop((int)80))));
        TropicraftPlacementUtil.register(context, MANGANESE, TropicraftMiscFeatures.MANGANESE, TropicraftPlacementUtil.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)8), (VerticalAnchor)VerticalAnchor.belowTop((int)32))));
        TropicraftPlacementUtil.register(context, SHAKA, TropicraftMiscFeatures.SHAKA, TropicraftPlacementUtil.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)8), (VerticalAnchor)VerticalAnchor.belowTop((int)32))));
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return Tropicraft.resourceKey(Registries.PLACED_FEATURE, name);
    }

    public static void addMudDisks(BiomeGenerationSettings.Builder generation) {
        generation.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MUD_DISK);
    }

    public static void addEih(BiomeGenerationSettings.Builder generation) {
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EIH);
    }

    public static void addTropicsGems(BiomeGenerationSettings.Builder generation) {
        TropicraftMiscPlacements.addOres(generation, AZURITE);
        TropicraftMiscPlacements.addOres(generation, EUDIALYTE);
        TropicraftMiscPlacements.addOres(generation, ZIRCON);
    }

    public static void addTropicsMetals(BiomeGenerationSettings.Builder generation) {
        TropicraftMiscPlacements.addOres(generation, MANGANESE);
        TropicraftMiscPlacements.addOres(generation, SHAKA);
    }

    private static void addOres(BiomeGenerationSettings.Builder generation, ResourceKey<PlacedFeature> feature) {
        generation.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, feature);
    }
}

