/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;

public class TropicraftPlacementUtil {
    @SafeVarargs
    public static Holder.Reference<PlacedFeature> registerRandomChecked(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<PlacedFeature> ... choices) {
        Holder randomConfigured = Holder.direct(TropicraftFeatureUtil.randomFeature(Arrays.asList(choices)));
        return context.register(key, (Object)new PlacedFeature(randomConfigured, List.of()));
    }

    public static Holder.Reference<PlacedFeature> register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> featureKey, List<PlacementModifier> placement) {
        Holder.Reference feature = context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(featureKey);
        return context.register(key, (Object)new PlacedFeature((Holder)feature, placement));
    }

    public static List<PlacementModifier> sparseTreePlacement(float chance) {
        return TropicraftPlacementUtil.treePlacement(0, chance, 1);
    }

    public static List<PlacementModifier> treePlacement(int count, float extraChance, int extraCount) {
        return List.of(PlacementUtils.countExtra((int)count, (float)extraChance, (int)extraCount), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_NO_LEAVES, BiomeFilter.biome());
    }

    public static List<PlacementModifier> orePlacement(PlacementModifier count, PlacementModifier height) {
        return List.of(count, InSquarePlacement.spread(), height, BiomeFilter.biome());
    }

    public static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier height) {
        return TropicraftPlacementUtil.orePlacement((PlacementModifier)CountPlacement.of((int)count), height);
    }
}

