/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.TropicraftPlacementUtil;
import net.tropicraft.core.common.dimension.feature.TropicraftTreeFeatures;

public final class TropicraftTreePlacements {
    public static final ResourceKey<PlacedFeature> GRAPEFRUIT_TREE_CHECKED = TropicraftTreePlacements.createKey("grapefruit_tree_checked");
    public static final ResourceKey<PlacedFeature> ORANGE_TREE_CHECKED = TropicraftTreePlacements.createKey("orange_tree_checked");
    public static final ResourceKey<PlacedFeature> LEMON_TREE_CHECKED = TropicraftTreePlacements.createKey("lemon_tree_checked");
    public static final ResourceKey<PlacedFeature> LIME_TREE_CHECKED = TropicraftTreePlacements.createKey("lime_tree_checked");
    public static final ResourceKey<PlacedFeature> PALM_TREE_CHECKED = TropicraftTreePlacements.createKey("palm_tree_checked");
    public static final ResourceKey<PlacedFeature> RAINFOREST_TALL_TREE_CHECKED = TropicraftTreePlacements.createKey("rainforest_tall_tree_checked");
    public static final ResourceKey<PlacedFeature> RAINFOREST_UP_TREE_CHECKED = TropicraftTreePlacements.createKey("rainforest_up_tree_checked");
    public static final ResourceKey<PlacedFeature> RAINFOREST_SMALL_TUALUNG_CHECKED = TropicraftTreePlacements.createKey("rainforest_small_tualung_checked");
    public static final ResourceKey<PlacedFeature> RAINFOREST_LARGE_TUALUNG_CHECKED = TropicraftTreePlacements.createKey("rainforest_large_tualung_checked");
    public static final ResourceKey<PlacedFeature> PLEODENDRON_CHECKED = TropicraftTreePlacements.createKey("pleodendron_checked");
    public static final ResourceKey<PlacedFeature> PAPAYA_CHECKED = TropicraftTreePlacements.createKey("papaya_checked");
    public static final ResourceKey<PlacedFeature> PLANTAIN_CHECKED = TropicraftTreePlacements.createKey("plantain_checked");
    public static final ResourceKey<PlacedFeature> RED_MANGROVE_CHECKED = TropicraftTreePlacements.createKey("red_mangrove_checked");
    public static final ResourceKey<PlacedFeature> TALL_MANGROVE_CHECKED = TropicraftTreePlacements.createKey("tall_mangrove_checked");
    public static final ResourceKey<PlacedFeature> TEA_MANGROVE_CHECKED = TropicraftTreePlacements.createKey("tea_mangrove_checked");
    public static final ResourceKey<PlacedFeature> BLACK_MANGROVE_CHECKED = TropicraftTreePlacements.createKey("black_mangrove_checked");
    public static final ResourceKey<PlacedFeature> LIGHT_MANGROVES_CHECKED = TropicraftTreePlacements.createKey("light_mangroves");

    public static void boostrap(BootstrapContext<PlacedFeature> context) {
        TropicraftPlacementUtil.register(context, GRAPEFRUIT_TREE_CHECKED, TropicraftTreeFeatures.GRAPEFRUIT_TREE, TropicraftTreePlacements.checkTree(TropicraftBlocks.GRAPEFRUIT_SAPLING));
        TropicraftPlacementUtil.register(context, ORANGE_TREE_CHECKED, TropicraftTreeFeatures.ORANGE_TREE, TropicraftTreePlacements.checkTree(TropicraftBlocks.ORANGE_SAPLING));
        TropicraftPlacementUtil.register(context, LEMON_TREE_CHECKED, TropicraftTreeFeatures.LEMON_TREE, TropicraftTreePlacements.checkTree(TropicraftBlocks.LEMON_SAPLING));
        TropicraftPlacementUtil.register(context, LIME_TREE_CHECKED, TropicraftTreeFeatures.LIME_TREE, TropicraftTreePlacements.checkTree(TropicraftBlocks.LIME_SAPLING));
        TropicraftPlacementUtil.register(context, PALM_TREE_CHECKED, TropicraftTreeFeatures.PALM_TREE, TropicraftTreePlacements.checkTree(TropicraftBlocks.PALM_SAPLING));
        TropicraftPlacementUtil.register(context, RAINFOREST_TALL_TREE_CHECKED, TropicraftTreeFeatures.RAINFOREST_TALL_TREE, TropicraftTreePlacements.checkTree(TropicraftBlocks.MAHOGANY_SAPLING));
        TropicraftPlacementUtil.register(context, RAINFOREST_UP_TREE_CHECKED, TropicraftTreeFeatures.RAINFOREST_UP_TREE, TropicraftTreePlacements.checkTree(TropicraftBlocks.MAHOGANY_SAPLING));
        TropicraftPlacementUtil.register(context, RAINFOREST_SMALL_TUALUNG_CHECKED, TropicraftTreeFeatures.RAINFOREST_SMALL_TUALUNG, TropicraftTreePlacements.checkTree(TropicraftBlocks.MAHOGANY_SAPLING));
        TropicraftPlacementUtil.register(context, RAINFOREST_LARGE_TUALUNG_CHECKED, TropicraftTreeFeatures.RAINFOREST_LARGE_TUALUNG, TropicraftTreePlacements.checkTree(TropicraftBlocks.MAHOGANY_SAPLING));
        TropicraftPlacementUtil.register(context, PLEODENDRON_CHECKED, TropicraftTreeFeatures.PLEODENDRON, TropicraftTreePlacements.checkTree(TropicraftBlocks.MAHOGANY_SAPLING));
        TropicraftPlacementUtil.register(context, PAPAYA_CHECKED, TropicraftTreeFeatures.PAPAYA, TropicraftTreePlacements.checkTree(TropicraftBlocks.PAPAYA_SAPLING));
        TropicraftPlacementUtil.register(context, PLANTAIN_CHECKED, TropicraftTreeFeatures.PLANTAIN, TropicraftTreePlacements.checkTree(TropicraftBlocks.PLANTAIN_SAPLING));
        TropicraftPlacementUtil.register(context, RED_MANGROVE_CHECKED, TropicraftTreeFeatures.RED_MANGROVE, TropicraftTreePlacements.checkMangrove(TropicraftBlocks.RED_MANGROVE_PROPAGULE, 2));
        Holder.Reference<PlacedFeature> tallMangrove = TropicraftPlacementUtil.register(context, TALL_MANGROVE_CHECKED, TropicraftTreeFeatures.TALL_MANGROVE, TropicraftTreePlacements.checkMangrove(TropicraftBlocks.TALL_MANGROVE_PROPAGULE, 2));
        Holder.Reference<PlacedFeature> teaMangrove = TropicraftPlacementUtil.register(context, TEA_MANGROVE_CHECKED, TropicraftTreeFeatures.TEA_MANGROVE, TropicraftTreePlacements.checkMangrove(TropicraftBlocks.TEA_MANGROVE_PROPAGULE, 1));
        Holder.Reference<PlacedFeature> blackMangrove = TropicraftPlacementUtil.register(context, BLACK_MANGROVE_CHECKED, TropicraftTreeFeatures.BLACK_MANGROVE, TropicraftTreePlacements.checkMangrove(TropicraftBlocks.BLACK_MANGROVE_PROPAGULE, 1));
        TropicraftPlacementUtil.registerRandomChecked(context, LIGHT_MANGROVES_CHECKED, new Holder[]{tallMangrove, teaMangrove, blackMangrove});
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return Tropicraft.resourceKey(Registries.PLACED_FEATURE, name);
    }

    private static List<PlacementModifier> checkTree(BlockEntry<?> sapling) {
        return List.of(TropicraftTreePlacements.saplingFilter(sapling));
    }

    private static List<PlacementModifier> checkMangrove(BlockEntry<?> sapling, int maxWaterDepth) {
        return List.of(SurfaceWaterDepthFilter.forMaxDepth((int)maxWaterDepth), TropicraftTreePlacements.saplingFilter(sapling));
    }

    private static BlockPredicateFilter saplingFilter(BlockEntry<?> sapling) {
        return BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)((Block)sapling.get()).defaultBlockState(), (Vec3i)BlockPos.ZERO));
    }
}

