/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.GravityProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.tropicraft.core.common.dimension.feature.jigsaw.PathStructureProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorTypes;

public class SmoothingGravityProcessor
extends PathStructureProcessor {
    public static final MapCodec<SmoothingGravityProcessor> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Heightmap.Types.CODEC.fieldOf("heightmap").forGetter(p -> p.heightmap), (App)Codec.INT.fieldOf("offset").forGetter(p -> p.offset)).apply((Applicative)i, SmoothingGravityProcessor::new));
    private final Heightmap.Types heightmap;
    private final int offset;
    private final GravityProcessor baseline;

    public SmoothingGravityProcessor(Heightmap.Types heightmap, int offset) {
        this.heightmap = heightmap;
        this.offset = offset;
        this.baseline = new GravityProcessor(heightmap, offset);
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos seedPos, BlockPos pos2, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placementSettingsIn, @Nullable StructureTemplate template) {
        Direction.Axis pathDir = this.getPathDirection(level, seedPos, blockInfo, placementSettingsIn, template);
        if (pathDir == null) {
            pathDir = Direction.Axis.X;
        }
        BlockPos pos = blockInfo.pos();
        BlockPos posForward = pos.relative(Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)pathDir));
        BlockPos posBackward = pos.relative(Direction.get((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)pathDir));
        int heightForward = level.getHeight(this.heightmap, posForward.getX(), posForward.getZ()) + this.offset;
        int heightBackward = level.getHeight(this.heightmap, posBackward.getX(), posBackward.getZ()) + this.offset;
        int height = level.getHeight(this.heightmap, pos.getX(), pos.getZ()) + this.offset;
        if (heightForward > height && heightBackward > height) {
            return new StructureTemplate.StructureBlockInfo(new BlockPos(pos.getX(), Math.min(heightForward, heightBackward), pos.getZ()), blockInfo.state(), blockInfo.nbt());
        }
        return this.baseline.process(level, seedPos, pos2, originalBlockInfo, blockInfo, placementSettingsIn, template);
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)TropicraftProcessorTypes.SMOOTHING_GRAVITY.get();
    }
}

