/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw.piece;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.IntersectionAllowedPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.TropicraftStructurePoolElementTypes;

public final class HomeTreeBranchPiece
extends StructurePoolElement
implements IntersectionAllowedPiece {
    public static final MapCodec<HomeTreeBranchPiece> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.FLOAT.fieldOf("min_angle").forGetter(c -> Float.valueOf(c.minAngle)), (App)Codec.FLOAT.fieldOf("max_angle").forGetter(c -> Float.valueOf(c.maxAngle))).apply((Applicative)i, HomeTreeBranchPiece::new));
    private static final int MAX_RADIUS = 48;
    private static final Direction.Axis[] ALL_AXIS = Direction.Axis.values();
    private static final CompoundTag JIGSAW_NBT = HomeTreeBranchPiece.createJigsawNbt();
    public final float minAngle;
    public final float maxAngle;

    public HomeTreeBranchPiece(float minAngle, float maxAngle) {
        super(StructureTemplatePool.Projection.RIGID);
        this.minAngle = minAngle;
        this.maxAngle = maxAngle;
    }

    public static Function<StructureTemplatePool.Projection, HomeTreeBranchPiece> create(float minAngle, float maxAngle) {
        return placementBehaviour -> new HomeTreeBranchPiece(minAngle, maxAngle);
    }

    private static CompoundTag createJigsawNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("name", "minecraft:bottom");
        nbt.putString("final_state", "minecraft:air");
        nbt.putString("pool", "minecraft:empty");
        nbt.putString("target", "minecraft:empty");
        nbt.putString("joint", JigsawBlockEntity.JointType.ROLLABLE.getSerializedName());
        return nbt;
    }

    public List<StructureTemplate.JigsawBlockInfo> getShuffledJigsawBlocks(StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation, RandomSource random) {
        FrontAndTop orientation = FrontAndTop.fromFrontAndTop((Direction)Direction.DOWN, (Direction)Direction.SOUTH);
        BlockState state = (BlockState)Blocks.JIGSAW.defaultBlockState().setValue((Property)JigsawBlock.ORIENTATION, (Comparable)orientation);
        return List.of(StructureTemplate.JigsawBlockInfo.of((StructureTemplate.StructureBlockInfo)new StructureTemplate.StructureBlockInfo(pos, state, JIGSAW_NBT)));
    }

    public Vec3i getSize(StructureTemplateManager templates, Rotation rotation) {
        return Vec3i.ZERO;
    }

    public BoundingBox getBoundingBox(StructureTemplateManager templates, BlockPos pos, Rotation rotation) {
        return new BoundingBox(pos.getX() - 48, pos.getY() - 48, pos.getZ() - 48, pos.getX() + 48, pos.getY() + 48, pos.getZ() + 48);
    }

    public boolean place(StructureTemplateManager templates, WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, BlockPos origin, BlockPos p_227341_, Rotation rotation, BoundingBox chunkBounds, RandomSource random, LiquidSettings liquidSettings, boolean p_227345_) {
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(level.getSeed()));
        rand.setDecorationSeed(level.getSeed(), origin.getX(), origin.getZ());
        int branchLength = rand.nextInt(10) + 15;
        int branchX1 = origin.getX();
        int branchZ1 = origin.getZ();
        double minAngle = Math.toRadians(this.minAngle);
        double maxAngle = Math.toRadians(this.maxAngle);
        double angle = minAngle + (double)rand.nextFloat() * (maxAngle - minAngle);
        int branchX2 = (int)((double)branchLength * Math.sin(angle) + (double)branchX1);
        int branchZ2 = (int)((double)branchLength * Math.cos(angle) + (double)branchZ1);
        int branchY2 = rand.nextInt(4) + 4;
        BlockState wood = ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).defaultBlockState();
        BlockState leaf = ((LeavesBlock)TropicraftBlocks.MAHOGANY_LEAVES.get()).defaultBlockState();
        int leafCircleSizeConstant = 3;
        int y2 = origin.getY() + branchY2;
        this.placeBlockLine(level, new BlockPos(branchX1, origin.getY(), branchZ1), new BlockPos(branchX2, y2, branchZ2), wood, chunkBounds);
        this.placeBlockLine(level, new BlockPos(branchX1 + 1, origin.getY(), branchZ1), new BlockPos(branchX2 + 1, y2, branchZ2), wood, chunkBounds);
        this.placeBlockLine(level, new BlockPos(branchX1 - 1, origin.getY(), branchZ1), new BlockPos(branchX2 - 1, y2, branchZ2), wood, chunkBounds);
        this.placeBlockLine(level, new BlockPos(branchX1, origin.getY(), branchZ1 + 1), new BlockPos(branchX2, y2, branchZ2 + 1), wood, chunkBounds);
        this.placeBlockLine(level, new BlockPos(branchX1, origin.getY(), branchZ1 - 1), new BlockPos(branchX2, y2, branchZ2 - 1), wood, chunkBounds);
        this.placeBlockLine(level, new BlockPos(branchX1, origin.getY() - 1, branchZ1), new BlockPos(branchX2, y2 - 1, branchZ2), wood, chunkBounds);
        this.placeBlockLine(level, new BlockPos(branchX1, origin.getY() + 1, branchZ1), new BlockPos(branchX2, y2 + 1, branchZ2), wood, chunkBounds);
        this.genLeafCircle(level, branchX2, y2 - 1, branchZ2, 8, 6, leaf, chunkBounds);
        this.genLeafCircle(level, branchX2, y2, branchZ2, 9, 0, leaf, chunkBounds);
        this.genLeafCircle(level, branchX2, y2 + 1, branchZ2, 13, 0, leaf, chunkBounds);
        this.genLeafCircle(level, branchX2, y2 + 2, branchZ2, 12, 0, leaf, chunkBounds);
        return true;
    }

    public void genLeafCircle(WorldGenLevel world, int x, int y, int z, int outerRadius, int innerRadius, BlockState state, BoundingBox chunkBounds) {
        int outerRadiusSquared = outerRadius * outerRadius;
        int innerRadiusSquared = innerRadius * innerRadius;
        BlockPos origin = new BlockPos(x, y, z);
        BoundingBox outerBounds = BoundingBox.fromCorners((Vec3i)origin.offset(-outerRadius, 0, -outerRadius), (Vec3i)origin.offset(outerRadius, 0, outerRadius));
        BoundingBox bounds = HomeTreeBranchPiece.intersection(chunkBounds, outerBounds);
        if (bounds == null) {
            return;
        }
        for (BlockPos pos : BlockPos.betweenClosed((int)bounds.minX(), (int)bounds.minY(), (int)bounds.minZ(), (int)bounds.maxX(), (int)bounds.maxY(), (int)bounds.maxZ())) {
            double distanceSquared = pos.distSqr((Vec3i)origin);
            if (!(distanceSquared <= (double)outerRadiusSquared) || !(distanceSquared >= (double)innerRadiusSquared) || !world.isEmptyBlock(pos) && !world.getBlockState(pos).is(state.getBlock())) continue;
            world.setBlock(pos, state, 3);
        }
    }

    private void placeBlockLine(WorldGenLevel world, BlockPos from, BlockPos to, BlockState state, BoundingBox chunkBounds) {
        Direction.Axis primaryAxis;
        BoundingBox lineBounds = BoundingBox.fromCorners((Vec3i)from, (Vec3i)to);
        if (!chunkBounds.intersects(lineBounds)) {
            return;
        }
        BlockPos delta = to.subtract((Vec3i)from);
        int maxLength = Math.abs(HomeTreeBranchPiece.getCoordinateAlong((Vec3i)delta, primaryAxis = this.getLongestAxis(delta)));
        if (maxLength == 0) {
            return;
        }
        double stepX = (double)HomeTreeBranchPiece.getCoordinateAlong((Vec3i)delta, Direction.Axis.X) / (double)maxLength;
        double stepY = (double)HomeTreeBranchPiece.getCoordinateAlong((Vec3i)delta, Direction.Axis.Y) / (double)maxLength;
        double stepZ = (double)HomeTreeBranchPiece.getCoordinateAlong((Vec3i)delta, Direction.Axis.Z) / (double)maxLength;
        for (int length = 0; length <= maxLength; ++length) {
            BlockPos pos = BlockPos.containing((double)((double)from.getX() + (double)length * stepX + 0.5), (double)((double)from.getY() + (double)length * stepY + 0.5), (double)((double)from.getZ() + (double)length * stepZ + 0.5));
            if (!chunkBounds.isInside((Vec3i)pos)) continue;
            world.setBlock(pos, state, 3);
        }
    }

    private Direction.Axis getLongestAxis(BlockPos delta) {
        Direction.Axis longestAxis = Direction.Axis.X;
        int longestLength = 0;
        for (Direction.Axis axis : ALL_AXIS) {
            int length = Math.abs(HomeTreeBranchPiece.getCoordinateAlong((Vec3i)delta, axis));
            if (length <= longestLength) continue;
            longestAxis = axis;
            longestLength = length;
        }
        return longestAxis;
    }

    @Nullable
    private static BoundingBox intersection(BoundingBox left, BoundingBox right) {
        if (!left.intersects(right)) {
            return null;
        }
        return new BoundingBox(Math.max(left.minX(), right.minX()), Math.max(left.minY(), right.minY()), Math.max(left.minZ(), right.minZ()), Math.min(left.maxX(), right.maxX()), Math.min(left.maxY(), right.maxY()), Math.min(left.maxZ(), right.maxZ()));
    }

    private static int getCoordinateAlong(Vec3i pos, Direction.Axis axis) {
        return axis.choose(pos.getX(), pos.getY(), pos.getZ());
    }

    public StructurePoolElementType<?> getType() {
        return (StructurePoolElementType)TropicraftStructurePoolElementTypes.HOME_TREE_BRANCH.get();
    }
}

