/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.tropicraft.core.common.block.FruitingBranchBlock;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTreeDecorators;

public class BranchTreeDecorator
extends TreeDecorator {
    public static final MapCodec<BranchTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(d -> Float.valueOf(d.probability)), (App)BlockStateProvider.CODEC.fieldOf("branch").forGetter(d -> d.branch), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("min_height").forGetter(d -> d.minHeight)).apply((Applicative)i, BranchTreeDecorator::new));
    private final float probability;
    private final BlockStateProvider branch;
    private final int minHeight;

    public BranchTreeDecorator(float probability, BlockStateProvider branch, int minHeight) {
        this.probability = probability;
        this.branch = branch;
        this.minHeight = minHeight;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)TropicraftTreeDecorators.BRANCH.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        ObjectArrayList logs = context.logs();
        int bottomLogY = ((BlockPos)logs.getFirst()).getY();
        for (BlockPos log : logs) {
            if (log.getY() - bottomLogY < this.minHeight) continue;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos pos;
                if (!(random.nextFloat() <= this.probability) || !context.isAir(pos = log.relative(direction.getOpposite()))) continue;
                context.setBlock(pos, (BlockState)this.branch.getState(random, pos).trySetValue(FruitingBranchBlock.FACING, (Comparable)direction.getOpposite()));
            }
        }
    }
}

