/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.PalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftLeavesFixer;

public class NormalPalmTreeFeature
extends PalmTreeFeature {
    public NormalPalmTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        BlockPos pos = context.origin();
        pos = pos.immutable();
        int height = random.nextInt(4) + 6;
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.getY(), height)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height)) {
            return false;
        }
        if (!this.getSapling().defaultBlockState().canSurvive((LevelReader)world, pos)) {
            return false;
        }
        if (world.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            world.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 3);
        }
        HashSet logs = Sets.newHashSet();
        HashSet leaves = Sets.newHashSet();
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i, j + height + 2, k);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i, j + height + 1, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i, j + height + 1, k + 2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i, j + height + 1, k + 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i, j + height, k + 4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 1, k);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 2, j + height + 1, k);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 3, j + height + 1, k);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 4, j + height, k);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i, j + height + 1, k - 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i, j + height + 1, k - 2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i, j + height + 1, k - 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i, j + height, k - 4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i - 1, j + height + 1, k);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i - 1, j + height + 1, k - 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i - 1, j + height + 1, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 1, k - 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 1, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i - 2, j + height + 1, k);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i - 3, j + height + 1, k);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i - 4, j + height, k);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 2, j + height + 1, k + 2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 2, j + height + 1, k - 2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i - 2, j + height + 1, k + 2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i - 2, j + height + 1, k - 2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 3, j + height, k + 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 3, j + height, k - 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i - 3, j + height, k + 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i - 3, j + height, k - 3);
        for (int j1 = 0; j1 < height + 2; ++j1) {
            BlockPos logPos = pos.above(j1);
            if (!TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)logPos)) continue;
            this.placeLog(logs, (LevelSimulatedRW)world, logPos);
        }
        NormalPalmTreeFeature.spawnCoconuts((LevelSimulatedRW)world, new BlockPos(i, j + height, k), random, 2, this.getLeaf());
        return TropicraftLeavesFixer.updateLeaves((LevelAccessor)world, logs, leaves, this.getLeaf());
    }
}

