/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftFoliagePlacers;

public class PleodendronFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<PleodendronFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> PleodendronFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(placer -> placer.height)).apply((Applicative)instance, PleodendronFoliagePlacer::new));
    protected final int height;

    public PleodendronFoliagePlacer(IntProvider radius, IntProvider offset, int height) {
        super(radius, offset);
        this.height = height;
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)TropicraftFoliagePlacers.PLEODENDRON.get();
    }

    protected void createFoliage(LevelSimulatedReader world, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int offset, FoliagePlacer.FoliageAttachment foliage, int y, int radius, int start) {
        int i = foliage.doubleTrunk() ? offset : 2;
        for (int j = start; j >= start - i; --j) {
            int k = y + foliage.radiusOffset() + 1 - j;
            this.placeLeavesRow(world, setter, random, config, foliage.pos(), k, j, foliage.doubleTrunk());
        }
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return this.height;
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean mega) {
        if (dx + dz >= 7) {
            return true;
        }
        return dx * dx + dz * dz > radius * radius;
    }
}

