/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.block.TropicraftBlocks;

public abstract class RainforestTreeFeature
extends Feature<NoneFeatureConfiguration> {
    protected static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};

    public RainforestTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    protected void setState(@Nullable Set<BlockPos> positions, LevelWriter world, BlockPos pos, BlockState state) {
        if (positions != null) {
            positions.add(pos);
        }
        this.setBlockStateInternally(world, pos, state);
    }

    private void setBlockStateInternally(LevelWriter world, BlockPos pos, BlockState state) {
        world.setBlock(pos, state, 19);
    }

    protected SaplingBlock getSapling() {
        return (SaplingBlock)TropicraftBlocks.MAHOGANY_SAPLING.get();
    }

    protected final BlockState getLeaf() {
        return ((LeavesBlock)TropicraftBlocks.KAPOK_LEAVES.get()).defaultBlockState();
    }

    protected final BlockState getLog() {
        return ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).defaultBlockState();
    }

    protected void placeLog(@Nullable Set<BlockPos> positions, LevelSimulatedRW world, int x, int y, int z) {
        this.setState(positions, (LevelWriter)world, new BlockPos(x, y, z), this.getLog());
    }

    protected void placeLog(@Nullable Set<BlockPos> positions, LevelSimulatedRW world, BlockPos pos) {
        this.setState(positions, (LevelWriter)world, pos, this.getLog());
    }

    protected boolean genCircle(Set<BlockPos> positions, LevelSimulatedRW world, int x, int y, int z, double outerRadius, double innerRadius, BlockState state, boolean solid) {
        return this.genCircle(positions, world, new BlockPos(x, y, z), outerRadius, innerRadius, state, solid);
    }

    @Nullable
    public ArrayList<int[]> placeBlockLine(Set<BlockPos> positions, LevelSimulatedRW world, int[] ai, int[] ai1, BlockState state) {
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = Mth.floor((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = Mth.floor((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = Mth.floor((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            BlockPos pos = new BlockPos(ai3[0], ai3[1], ai3[2]);
            this.setState(positions, (LevelWriter)world, pos, state);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
        }
        return places;
    }

    public boolean genCircle(Set<BlockPos> positions, LevelSimulatedRW world, BlockPos pos, double outerRadius, double innerRadius, BlockState state, boolean solid) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        boolean hasGenned = false;
        for (int i = (int)(-outerRadius - 1.0) + x; i <= (int)(outerRadius + 1.0) + x; ++i) {
            for (int k = (int)(-outerRadius - 1.0) + z; k <= (int)(outerRadius + 1.0) + z; ++k) {
                BlockPos pos2;
                double d = (i - x) * (i - x) + (k - z) * (k - z);
                if (!(d <= outerRadius * outerRadius) || !(d >= innerRadius * innerRadius) || !world.isStateAtPosition(pos2 = new BlockPos(i, y, k), BlockBehaviour.BlockStateBase::isAir) && !solid || !world.setBlock(pos2, state, 3)) continue;
                positions.add(pos2);
                hasGenned = true;
            }
        }
        return hasGenned;
    }
}

