/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.config.RainforestVinesConfig;

public class RainforestVinesFeature
extends Feature<RainforestVinesConfig> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public RainforestVinesFeature(Codec<RainforestVinesConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RainforestVinesConfig> context) {
        WorldGenLevel world = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        RainforestVinesConfig config = (RainforestVinesConfig)context.config();
        BlockPos.MutableBlockPos mutablePos = pos.mutable();
        int maxY = Math.min(pos.getY() + config.height, world.getMaxY());
        for (int y = pos.getY(); y < maxY; ++y) {
            block1: for (int i = 0; i < config.rollsPerY; ++i) {
                mutablePos.set((Vec3i)pos);
                mutablePos.move(rand.nextInt(config.xzSpread * 2) - config.xzSpread, 0, rand.nextInt(config.xzSpread * 2) - config.xzSpread);
                mutablePos.setY(y);
                if (!world.isEmptyBlock((BlockPos)mutablePos)) continue;
                for (Direction direction : DIRECTIONS) {
                    mutablePos.move(direction);
                    BlockState attaching = world.getBlockState((BlockPos)mutablePos);
                    if ((!attaching.is(Blocks.GRASS_BLOCK) || rand.nextInt(4) != 0) && !RainforestVinesFeature.canPlaceVineOn(attaching) || direction == Direction.DOWN || !VineBlock.isAcceptableNeighbour((BlockGetter)world, (BlockPos)mutablePos, (Direction)direction)) continue;
                    mutablePos.move(direction.getOpposite());
                    int len = rand.nextInt(7) + 4;
                    for (int j = 0; j < len && world.isEmptyBlock((BlockPos)mutablePos); ++j) {
                        world.setBlock((BlockPos)mutablePos, (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)VineBlock.getPropertyForFace((Direction)direction), (Comparable)Boolean.valueOf(true)), 2);
                        mutablePos.move(Direction.DOWN);
                    }
                    continue block1;
                }
            }
        }
        return true;
    }

    private static boolean canPlaceVineOn(BlockState attaching) {
        return attaching.is(BlockTags.LEAVES) && !attaching.is(TropicraftBlocks.PALM_LEAVES) || attaching.is(BlockTags.LOGS);
    }
}

