/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftLeavesFixer;

public class TallRainforestTreeFeature
extends RainforestTreeFeature {
    public static final List<BlockPos> BRANCH_DIRECTIONS = BlockPos.betweenClosedStream((int)-1, (int)0, (int)-1, (int)1, (int)0, (int)1).map(BlockPos::immutable).filter(blockPos -> !blockPos.equals((Object)BlockPos.ZERO)).toList();
    private static final int VINE_CHANCE = 5;
    private static final int SMALL_LEAF_CHANCE = 3;
    private static final int SECOND_CANOPY_CHANCE = 3;

    public TallRainforestTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    private boolean isSoil(LevelAccessor world, BlockPos pos) {
        return this.getSapling().defaultBlockState().canSurvive((LevelReader)world, pos);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos local;
        int dy;
        int dz;
        int w;
        WorldGenLevel world = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        pos = pos.immutable();
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        int height = rand.nextInt(10) + 25;
        WorldgenRandom r = new WorldgenRandom((RandomSource)new LegacyRandomSource(world.getSeed()));
        r.setLargeFeatureSeed(world.getSeed(), i >> 4, k >> 4);
        if (r.nextInt(10) == 0) {
            return false;
        }
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.getY(), height)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height)) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.below())) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.east().below())) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.west().below())) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.north().below())) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.south().below())) {
            return false;
        }
        HashSet logs = Sets.newHashSet();
        HashSet leaves = Sets.newHashSet();
        this.setState(null, (LevelWriter)world, new BlockPos(i, j - 1, k), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i - 1, j - 1, k), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i + 1, j - 1, k), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i, j - 1, k - 1), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i, j - 1, k + 1), Blocks.DIRT.defaultBlockState());
        double branchDelta = rand.nextDouble() * 2.0943951023931953;
        for (int y = j; y < j + height; ++y) {
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i - 1, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i + 1, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k - 1);
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k + 1);
            if (y > j + 8 && y < j + height - 6 && y % 3 == 0 && rand.nextInt(3) > 0) {
                int baseBranchSize = (int)Mth.clampedMap((float)y, (float)j, (float)(j + height), (float)4.0f, (float)8.0f);
                int branchLen = baseBranchSize + rand.nextInt(3);
                for (int by = 0; by < branchLen; ++by) {
                    int dx = (int)(Math.cos(branchDelta) * (double)by);
                    int dz2 = (int)(Math.sin(branchDelta) * (double)by);
                    int dy2 = by / 2;
                    BlockPos local2 = pos.atY(y + dy2).offset(dx, 0, dz2);
                    this.placeLog(logs, (LevelSimulatedRW)world, local2);
                    if (by != branchLen - 1) continue;
                    this.genCircle(leaves, (LevelSimulatedRW)world, local2.above(), 3.0, 0.0, this.getLeaf(), false);
                    this.genCircle(leaves, (LevelSimulatedRW)world, local2, 4.0, 3.0, this.getLeaf(), false);
                    this.genCircle(leaves, (LevelSimulatedRW)world, local2.below(), 5.0, 4.0, this.getLeaf(), false);
                }
                branchDelta += 2.0943951023931953 + (rand.nextDouble() - rand.nextDouble()) * 0.5235987755982988;
            }
            if (y - j <= 4 || rand.nextInt(3) != 0) continue;
            int nx = rand.nextInt(3) - 1 + i;
            int nz = rand.nextInt(3) - 1 + k;
            this.genCircle(leaves, (LevelSimulatedRW)world, new BlockPos(nx, y + 1, nz), 1.0, 0.0, this.getLeaf(), false);
            this.genCircle(leaves, (LevelSimulatedRW)world, nx, y, nz, 2.0, 1.0, this.getLeaf(), false);
        }
        int branchSize = rand.nextInt(3) + 6;
        double topBranchDelta = rand.nextDouble() * 1.0471975511965976;
        for (int v = 0; v < 6; ++v) {
            int branchHeight = 3 + (rand.nextInt(3) - rand.nextInt(3));
            int branchMod = branchSize / branchHeight;
            for (w = 0; w < branchSize; ++w) {
                int dx = (int)(Math.cos(topBranchDelta) * (double)(w + 2));
                dz = (int)(Math.sin(topBranchDelta) * (double)(w + 2));
                dy = w / branchMod;
                local = pos.atY(j + height + dy).offset(dx, 0, dz);
                this.placeLog(logs, (LevelSimulatedRW)world, local);
                if (w != branchSize - 1) continue;
                int canopySize = 4 + rand.nextInt(3);
                this.genCircle(leaves, (LevelSimulatedRW)world, local.above(), canopySize, 0.0, this.getLeaf(), false);
                this.genCircle(leaves, (LevelSimulatedRW)world, local, canopySize + 1, canopySize, this.getLeaf(), false);
                this.genCircle(leaves, (LevelSimulatedRW)world, local.below(), canopySize + 2, canopySize + 1, this.getLeaf(), false);
            }
            topBranchDelta += 1.0471975511965976;
        }
        double delta = rand.nextDouble() * 2.0943951023931953;
        for (int v = 0; v < 3; ++v) {
            for (w = 0; w < 3; ++w) {
                int dx = (int)(Math.cos(delta) * (double)(w + 2));
                dz = (int)(Math.sin(delta) * (double)(w + 2));
                dy = -w;
                this.placeLog(logs, (LevelSimulatedRW)world, pos.offset(dx, dy, dz));
                this.placeLog(logs, (LevelSimulatedRW)world, pos.offset(dx + 1, dy, dz));
                this.placeLog(logs, (LevelSimulatedRW)world, pos.offset(dx, dy, dz + 1));
                this.placeLog(logs, (LevelSimulatedRW)world, pos.offset(dx - 1, dy, dz));
                this.placeLog(logs, (LevelSimulatedRW)world, pos.offset(dx, dy, dz - 1));
            }
            delta += 2.0943951023931953;
        }
        BlockState state = TropicraftBlocks.FLOWERS.get(TropicraftFlower.MAGIC_MUSHROOM).getDefaultState();
        if (rand.nextInt(4) == 0) {
            state = Blocks.FIREFLY_BUSH.defaultBlockState();
        }
        for (int m = 0; m < 24; ++m) {
            int dx = rand.nextInt(12) - rand.nextInt(12);
            dz = rand.nextInt(12) - rand.nextInt(12);
            dy = rand.nextInt(5) - rand.nextInt(5);
            local = pos.offset(dx, dy, dz);
            if (!world.getBlockState(local).canBeReplaced() || !world.getBlockState(local.below()).is(Blocks.GRASS_BLOCK)) continue;
            world.setBlock(local, state, 3);
        }
        return TropicraftLeavesFixer.updateLeaves((LevelAccessor)world, logs, leaves, this.getLeaf());
    }
}

