/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.tropicraft.core.common.block.TropicraftLeavesBlock;

public class TropicraftLeavesFixer {
    private static final List<BlockPos> VANILLA_OFFSETS = Arrays.stream(Direction.values()).map(d -> new BlockPos(d.getStepX(), d.getStepY(), d.getStepZ())).toList();

    public static boolean updateLeaves(LevelAccessor level, Set<BlockPos> logs, Set<BlockPos> leaves, BlockState leavesBlock) {
        boolean extendedDecay = leavesBlock.getBlock() instanceof TropicraftLeavesBlock;
        return BoundingBox.encapsulatingPositions((Iterable)Iterables.concat(logs, leaves)).map(box -> {
            DiscreteVoxelShape leavesShape = TropicraftLeavesFixer.buildShapeAndAssignDistances(level, box, logs, extendedDecay ? TropicraftLeavesBlock.AROUND_OFFSETS : VANILLA_OFFSETS);
            StructureTemplate.updateShapeAtEdge((LevelAccessor)level, (int)3, (DiscreteVoxelShape)leavesShape, (int)box.minX(), (int)box.minY(), (int)box.minZ());
            return true;
        }).orElse(false);
    }

    private static DiscreteVoxelShape buildShapeAndAssignDistances(LevelAccessor level, BoundingBox box, Set<BlockPos> logs, List<BlockPos> neighborOffsets) {
        int currentDistance;
        BitSetDiscreteVoxelShape voxelShape = new BitSetDiscreteVoxelShape(box.getXSpan(), box.getYSpan(), box.getZSpan());
        ArrayList queuesByDistance = new ArrayList(7);
        for (int i = 0; i < 7; ++i) {
            queuesByDistance.add(new HashSet());
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        ((Set)queuesByDistance.get(currentDistance)).addAll(logs);
        for (currentDistance = 0; currentDistance < 7; ++currentDistance) {
            while (!((Set)queuesByDistance.get(currentDistance)).isEmpty()) {
                Iterator iterator = ((Set)queuesByDistance.get(currentDistance)).iterator();
                BlockPos blockPos = (BlockPos)iterator.next();
                iterator.remove();
                if (!box.isInside((Vec3i)blockPos)) continue;
                if (currentDistance != 0) {
                    BlockState leafState = level.getBlockState(blockPos);
                    TropicraftLeavesFixer.setBlockKnownShape((LevelWriter)level, blockPos, (BlockState)leafState.setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(currentDistance)));
                }
                voxelShape.fill(blockPos.getX() - box.minX(), blockPos.getY() - box.minY(), blockPos.getZ() - box.minZ());
                for (BlockPos offset : neighborOffsets) {
                    int newDistance;
                    BlockState neighborState;
                    OptionalInt neighborDistance;
                    mutablePos.setWithOffset((Vec3i)blockPos, (Vec3i)offset);
                    if (!box.isInside((Vec3i)mutablePos) || voxelShape.isFull(mutablePos.getX() - box.minX(), mutablePos.getY() - box.minY(), mutablePos.getZ() - box.minZ()) || !(neighborDistance = TropicraftLeavesBlock.getOptionalDistanceAt((BlockState)(neighborState = level.getBlockState((BlockPos)mutablePos)))).isPresent() || (newDistance = Math.min(neighborDistance.getAsInt(), currentDistance + 1)) >= 7) continue;
                    ((Set)queuesByDistance.get(newDistance)).add(mutablePos.immutable());
                    currentDistance = Math.min(currentDistance, newDistance);
                }
            }
        }
        return voxelShape;
    }

    private static void setBlockKnownShape(LevelWriter level, BlockPos pos, BlockState state) {
        level.setBlock(pos, state, 19);
    }
}

