/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftLeavesFixer;

public class TualungFeature
extends RainforestTreeFeature {
    private final int baseHeight;
    private final int maxHeight;

    public TualungFeature(Codec<NoneFeatureConfiguration> codec, int maxHeight, int baseHeight) {
        super(codec);
        this.baseHeight = baseHeight;
        this.maxHeight = maxHeight;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int dz;
        int dx;
        WorldGenLevel world = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        pos = pos.immutable();
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        int height = rand.nextInt(this.maxHeight - this.baseHeight) + this.baseHeight + j;
        WorldgenRandom r = new WorldgenRandom((RandomSource)new LegacyRandomSource(world.getSeed()));
        r.setLargeFeatureSeed(world.getSeed(), i >> 4, k >> 4);
        if (r.nextInt(10) == 0) {
            return false;
        }
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.getY(), height - j)) {
            return false;
        }
        if (height + 6 > world.getMaxY()) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height - j)) {
            return false;
        }
        if (!this.getSapling().defaultBlockState().canSurvive((LevelReader)world, pos)) {
            return false;
        }
        HashSet logs = Sets.newHashSet();
        HashSet leaves = Sets.newHashSet();
        this.setState(null, (LevelWriter)world, new BlockPos(i, j - 1, k), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i - 1, j - 1, k), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i + 1, j - 1, k), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i, j - 1, k - 1), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i, j - 1, k + 1), Blocks.DIRT.defaultBlockState());
        for (int y = j; y < height; ++y) {
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i - 1, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i + 1, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k - 1);
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k + 1);
            if (y - j <= 4 || rand.nextInt(3) != 0) continue;
            int nx = rand.nextInt(3) - 1 + i;
            int nz = rand.nextInt(3) - 1 + k;
            this.genCircle(leaves, (LevelSimulatedRW)world, new BlockPos(nx, y + 1, nz), 1.0, 0.0, this.getLeaf(), false);
            this.genCircle(leaves, (LevelSimulatedRW)world, nx, y, nz, 2.0, 1.0, this.getLeaf(), false);
        }
        int branches = rand.nextInt(3) + 3;
        double branchDelta = rand.nextDouble() * (Math.PI * 2 / (double)branches);
        for (int b = 0; b < branches; ++b) {
            int size = 8 + rand.nextInt(5);
            for (int by = 0; by < size; ++by) {
                int dx2 = (int)(Math.cos(branchDelta) * ((double)by / 1.5));
                int dz2 = (int)(Math.sin(branchDelta) * ((double)by / 1.5));
                int dy = by - 4;
                BlockPos local = pos.atY(height + dy).offset(dx2, 0, dz2);
                this.placeLog(logs, (LevelSimulatedRW)world, local);
                if (by != size - 1) continue;
                this.genCircle(leaves, (LevelSimulatedRW)world, local.above(), 3.0, 0.0, this.getLeaf(), false);
                this.genCircle(leaves, (LevelSimulatedRW)world, local, 4.0, 3.0, this.getLeaf(), false);
                this.genCircle(leaves, (LevelSimulatedRW)world, local.below(), 5.0, 4.0, this.getLeaf(), false);
            }
            branchDelta += Math.PI * 2 / (double)branches;
        }
        double delta = rand.nextDouble() * 2.0943951023931953;
        for (int v = 0; v < 3; ++v) {
            for (int w = 0; w < 3; ++w) {
                dx = (int)(Math.cos(delta) * (double)(w + 2));
                dz = (int)(Math.sin(delta) * (double)(w + 2));
                int dy = -w;
                this.placeLog(logs, (LevelSimulatedRW)world, pos.offset(dx, dy, dz));
                this.placeLog(logs, (LevelSimulatedRW)world, pos.offset(dx + 1, dy, dz));
                this.placeLog(logs, (LevelSimulatedRW)world, pos.offset(dx, dy, dz + 1));
                this.placeLog(logs, (LevelSimulatedRW)world, pos.offset(dx - 1, dy, dz));
                this.placeLog(logs, (LevelSimulatedRW)world, pos.offset(dx, dy, dz - 1));
            }
            delta += 2.0943951023931953;
        }
        BlockState state = TropicraftBlocks.FLOWERS.get(TropicraftFlower.MAGIC_MUSHROOM).getDefaultState();
        if (rand.nextInt(4) == 0) {
            state = Blocks.FIREFLY_BUSH.defaultBlockState();
        }
        for (int m = 0; m < 24; ++m) {
            dx = rand.nextInt(12) - rand.nextInt(12);
            dz = rand.nextInt(12) - rand.nextInt(12);
            int dy = rand.nextInt(5) - rand.nextInt(5);
            BlockPos local = pos.offset(dx, dy, dz);
            if (!world.getBlockState(local).canBeReplaced() || !world.getBlockState(local.below()).is(Blocks.GRASS_BLOCK)) continue;
            world.setBlock(local, state, 3);
        }
        return TropicraftLeavesFixer.updateLeaves((LevelAccessor)world, logs, leaves, this.getLeaf());
    }

    private int sign(int i) {
        return i == 0 ? 0 : (i <= 0 ? -1 : 1);
    }
}

