/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree.mangrove;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.material.Fluids;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.MangroveRootsBlock;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTrunkPlacers;

public final class MangroveTrunkPlacer
extends FancyTrunkPlacer {
    public static final MapCodec<MangroveTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(i -> MangroveTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)i).and(i.group((App)BlockStateProvider.CODEC.fieldOf("roots_block").forGetter(c -> c.rootsBlock), (App)Codec.BOOL.fieldOf("can_generate_raised").forGetter(c -> c.canGenerateRaised), (App)Codec.BOOL.fieldOf("tea_mangrove").forGetter(c -> c.teaMangrove))).apply((Applicative)i, MangroveTrunkPlacer::new));
    private static final int MIN_LENGTH = 2;
    private static final int MAX_LENGTH = 4;
    private static final int MAX_RADIUS = 4;
    private static final int MAX_SIZE = 9;
    private final BlockStateProvider rootsBlock;
    private final boolean canGenerateRaised;
    private final boolean teaMangrove;

    public MangroveTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, BlockStateProvider rootsBlock, boolean canGenerateRaised, boolean teaMangrove) {
        super(baseHeight, heightRandA, heightRandB);
        this.rootsBlock = rootsBlock;
        this.canGenerateRaised = canGenerateRaised;
        this.teaMangrove = teaMangrove;
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)TropicraftTrunkPlacers.MANGROVE.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> acceptor, RandomSource random, int height, BlockPos origin, TreeConfiguration config) {
        int waterDepth;
        int rootLength = Mth.clamp((int)(height - 5), (int)2, (int)4);
        boolean placeDirtOnOrigin = world.isStateAtPosition(origin.below(), b -> b.is(Blocks.GRASS_BLOCK));
        if (this.canGenerateRaised && (waterDepth = this.getWaterDepthAbove(world, origin, 3)) <= 2 && random.nextInt(2) == 0) {
            int surfaceY = origin.getY() + waterDepth;
            origin = new BlockPos(origin.getX(), surfaceY + 1, origin.getZ());
            placeDirtOnOrigin = false;
        }
        RootSystem roots = new RootSystem();
        if (this.teaMangrove) {
            this.growTeaRoots(roots, rootLength);
        } else {
            this.growRoots(roots, random, rootLength);
        }
        this.placeRoots((LevelSimulatedRW)world, origin, rootLength, roots, random);
        if (placeDirtOnOrigin) {
            MangroveTrunkPlacer.setDirtAt((LevelSimulatedReader)world, acceptor, (RandomSource)random, (BlockPos)origin.below(), (TreeConfiguration)config);
        }
        for (int i = 0; i < height; ++i) {
            this.placeLog(world, acceptor, random, origin.above(i), config);
        }
        ArrayList<FoliagePlacer.FoliageAttachment> leafNodes = new ArrayList<FoliagePlacer.FoliageAttachment>();
        leafNodes.add(new FoliagePlacer.FoliageAttachment(origin.above(height), 1, false));
        this.growBranches((LevelSimulatedRW)world, acceptor, random, height, origin, config, leafNodes);
        return leafNodes;
    }

    private int getWaterDepthAbove(LevelSimulatedReader world, BlockPos origin, int maxDepth) {
        int depth;
        BlockPos.MutableBlockPos pos = origin.mutable();
        for (depth = 0; depth <= maxDepth; ++depth) {
            pos.setY(origin.getY() + depth);
            if (!MangroveTrunkPlacer.isWaterAt(world, (BlockPos)pos)) break;
        }
        return depth;
    }

    private void growBranches(LevelSimulatedRW world, BiConsumer<BlockPos, BlockState> acceptor, RandomSource random, int height, BlockPos origin, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> leafNodes) {
        int count = 2 + random.nextInt(3);
        Direction lastDirection = null;
        block0: for (int i = 0; i < count; ++i) {
            Direction direction;
            BlockPos base = origin.above(height - count + i);
            int length = 1 + random.nextInt(2);
            boolean hasBranch = false;
            while ((direction = Direction.Plane.HORIZONTAL.getRandomDirection(random)) == lastDirection) {
            }
            lastDirection = direction;
            for (int j = 1; j <= length + 1; ++j) {
                if (j == length) {
                    this.placeLog((LevelSimulatedReader)world, acceptor, random, base.relative(direction, j).above(), config);
                    leafNodes.add(new FoliagePlacer.FoliageAttachment(base.relative(direction, j).above(), random.nextInt(2), false));
                    continue block0;
                }
                if (!hasBranch && random.nextBoolean()) {
                    hasBranch = true;
                    Direction branchBranchDir = random.nextBoolean() ? direction.getClockWise() : direction.getCounterClockWise();
                    this.placeLog((LevelSimulatedReader)world, acceptor, random, base.relative(direction, j).relative(branchBranchDir), config);
                    leafNodes.add(new FoliagePlacer.FoliageAttachment(base.relative(direction, j).relative(branchBranchDir), 0, false));
                }
                this.placeLog((LevelSimulatedReader)world, acceptor, random, base.relative(direction, j), config);
            }
        }
    }

    private void growRoots(RootSystem roots, RandomSource random, int length) {
        RootGrower grower = new RootGrower(roots);
        grower.growAt(RootSystem.pos(-1, 0), RootSystem.seed(Direction.WEST));
        grower.growAt(RootSystem.pos(1, 0), RootSystem.seed(Direction.EAST));
        grower.growAt(RootSystem.pos(0, -1), RootSystem.seed(Direction.NORTH));
        grower.growAt(RootSystem.pos(0, 1), RootSystem.seed(Direction.SOUTH));
        while (grower.hasNext()) {
            int pos = grower.nextPos();
            int root = roots.get(pos);
            int distance = RootSystem.distance(root);
            if (distance >= length || random.nextInt(8) == 0) continue;
            Direction side = RootSystem.side(root);
            Direction flow = RootSystem.flow(root);
            if (random.nextInt((length - distance >> 1) + 1) == 0) {
                if (distance <= 1 || random.nextBoolean()) {
                    grower.growOut(pos, distance, side, flow);
                }
                grower.growOut(pos, distance, side, MangroveTrunkPlacer.nextFlow(random, flow));
                continue;
            }
            grower.growOut(pos, distance, side, flow);
        }
    }

    private static Direction nextFlow(RandomSource random, Direction side) {
        return switch (random.nextInt(3)) {
            case 0 -> side.getClockWise();
            case 1 -> side.getCounterClockWise();
            default -> side;
        };
    }

    private void growTeaRoots(RootSystem roots, int length) {
        int radius = length / 2;
        for (int z = -radius; z <= radius; ++z) {
            for (int x = -radius; x <= radius; ++x) {
                if (x == 0 && z == 0) continue;
                int distance = (Math.abs(x) + Math.abs(z) - 1) * 2;
                roots.set(RootSystem.pos(x, z), RootSystem.root(distance));
            }
        }
    }

    private void placeRoots(LevelSimulatedRW world, BlockPos origin, int rootLength, RootSystem roots, RandomSource random) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int z = -4; z <= 4; ++z) {
            for (int x = -4; x <= 4; ++x) {
                int root = roots.get(RootSystem.pos(x, z));
                if (root == 0) continue;
                mutablePos.set(origin.getX() + x, 0, origin.getZ() + z);
                int rootHeight = rootLength - RootSystem.distance(root);
                if (rootHeight <= 0) continue;
                int maxY = origin.getY() + rootHeight;
                int minY = maxY - 8;
                int y = maxY;
                while (y >= minY) {
                    mutablePos.setY(y--);
                    if (this.setRootsAt(world, (BlockPos)mutablePos, random)) continue;
                }
            }
        }
    }

    private boolean setRootsAt(LevelSimulatedRW world, BlockPos pos, RandomSource random) {
        return MangroveTrunkPlacer.setRootsAt(world, pos, this.rootsBlock.getState(random, pos));
    }

    public static boolean setRootsAt(LevelSimulatedRW world, BlockPos pos, BlockState rootsBlock) {
        if (MangroveTrunkPlacer.isReplaceableAt((LevelSimulatedReader)world, pos)) {
            BlockState state = (BlockState)rootsBlock.setValue((Property)MangroveRootsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(MangroveTrunkPlacer.isWaterAt((LevelSimulatedReader)world, pos)));
            world.setBlock(pos, state, 19);
            return true;
        }
        return false;
    }

    public static boolean isReplaceableAt(LevelSimulatedReader world, BlockPos pos) {
        return world.isStateAtPosition(pos, state -> state.isAir() || state.is(BlockTags.REPLACEABLE_BY_TREES) || state.is(TropicraftTags.Blocks.ROOTS));
    }

    public static boolean isWaterAt(LevelSimulatedReader world, BlockPos pos) {
        return world.isStateAtPosition(pos, state -> state.getFluidState().getType() == Fluids.WATER);
    }

    static final class RootSystem {
        static final int NULL = 0;
        private final int[] map = new int[81];

        RootSystem() {
        }

        boolean set(int pos, int root) {
            if (!this.contains(pos)) {
                this.map[pos] = root;
                return true;
            }
            return false;
        }

        int get(int pos) {
            return this.map[pos];
        }

        boolean contains(int pos) {
            return this.get(pos) != 0;
        }

        static int pos(int x, int z) {
            return x + 4 + (z + 4) * 9;
        }

        static int offsetPos(int pos, int x, int z) {
            return pos + x + z * 9;
        }

        static int seed(Direction side) {
            return RootSystem.root(1, side, side);
        }

        static int root(int distance, Direction side, Direction flow) {
            return RootSystem.root(distance) | side.get2DDataValue() << 3 | flow.get2DDataValue() << 1;
        }

        static int root(int distance) {
            return distance << 5 | 1;
        }

        static int distance(int root) {
            return root >> 5;
        }

        static Direction side(int root) {
            return Direction.from2DDataValue((int)(root >> 3 & 3));
        }

        static Direction flow(int root) {
            return Direction.from2DDataValue((int)(root >> 1 & 3));
        }
    }

    static final class RootGrower {
        private final RootSystem roots;
        private final IntArrayFIFOQueue queue = new IntArrayFIFOQueue();

        RootGrower(RootSystem roots) {
            this.roots = roots;
        }

        boolean hasNext() {
            return !this.queue.isEmpty();
        }

        int nextPos() {
            return this.queue.dequeueInt();
        }

        void growOut(int pos, int distance, Direction side, Direction flow) {
            int growPos = RootSystem.offsetPos(pos, flow.getStepX(), flow.getStepZ());
            this.growAt(growPos, RootSystem.root(distance + 1, side, flow));
        }

        void growAt(int pos, int root) {
            if (this.roots.set(pos, root)) {
                this.queue.enqueue(pos);
            }
        }
    }
}

