/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.volcano;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.tropicraft.core.common.dimension.feature.TropicraftStructureTypes;
import net.tropicraft.core.common.dimension.feature.volcano.VolcanoStructurePiece;

public class VolcanoStructure
extends Structure {
    public static final MapCodec<VolcanoStructure> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)VolcanoStructure.settingsCodec((RecordCodecBuilder.Instance)i), (App)HeightProvider.CODEC.fieldOf("height").forGetter(s -> s.height), (App)IntProvider.CODEC.fieldOf("radius").forGetter(s -> s.radius)).apply((Applicative)i, VolcanoStructure::new));
    private final HeightProvider height;
    private final IntProvider radius;

    public VolcanoStructure(Structure.StructureSettings settings, HeightProvider height, IntProvider radius) {
        super(settings);
        this.height = height;
        this.radius = radius;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        WorldgenRandom random = context.random();
        int height = this.height.sample((RandomSource)random, new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        int radiusX = this.radius.sample((RandomSource)random);
        int radiusZ = this.radius.sample((RandomSource)random);
        long noiseSeed = random.nextLong();
        BlockPos pos = new BlockPos(chunkPos.getMinBlockX() + 8, height, chunkPos.getMinBlockZ() + 8);
        return Optional.of(new Structure.GenerationStub(pos, builder -> builder.addPiece((StructurePiece)new VolcanoStructurePiece(context.heightAccessor(), pos, radiusX, radiusZ, noiseSeed))));
    }

    public StructureType<?> type() {
        return (StructureType)TropicraftStructureTypes.VOLCANO.get();
    }
}

