/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.volcano;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.VolcanicSandBlock;
import net.tropicraft.core.common.block.VolcanoBlock;
import net.tropicraft.core.common.block.tileentity.VolcanoBlockEntity;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.TropicraftStructurePieceTypes;

public class VolcanoStructurePiece
extends StructurePiece {
    private static final int CALDERA_CUTOFF = 194;
    private static final int VOLCANO_TOP = 187;
    public static final int VOLCANO_CRUST = 184;
    public static final int LAVA_LEVEL = 149;
    private static final int CRUST_HOLE_CHANCE = 15;
    private static final float STEEPNESS = 10.2f;
    private final int radiusX;
    private final int radiusZ;
    private final long noiseSeed;
    private final ImprovedNoise noise;

    protected VolcanoStructurePiece(LevelHeightAccessor heightAccessor, BlockPos pos, int radiusX, int radiusZ, long noiseSeed) {
        super((StructurePieceType)TropicraftStructurePieceTypes.VOLCANO.get(), 0, VolcanoStructurePiece.boundingBox(heightAccessor, pos, radiusX, radiusZ));
        this.radiusX = radiusX;
        this.radiusZ = radiusZ;
        this.noiseSeed = noiseSeed;
        this.noise = VolcanoStructurePiece.createNoise(noiseSeed);
    }

    public VolcanoStructurePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super((StructurePieceType)TropicraftStructurePieceTypes.VOLCANO.get(), tag);
        this.radiusX = tag.getIntOr("radius_x", 1);
        this.radiusZ = tag.getIntOr("radius_z", 1);
        this.noiseSeed = tag.getLongOr("noise_seed", 0L);
        this.noise = VolcanoStructurePiece.createNoise(this.noiseSeed);
    }

    private static BoundingBox boundingBox(LevelHeightAccessor heightAccessor, BlockPos pos, int radiusX, int radiusZ) {
        return new BoundingBox(pos.getX() - radiusX - 1, pos.getY(), pos.getZ() - radiusZ - 1, pos.getX() + radiusX + 1, heightAccessor.getMaxY(), pos.getZ() + radiusZ + 1);
    }

    private static ImprovedNoise createNoise(long seed) {
        return new ImprovedNoise(RandomSource.create((long)seed));
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.putInt("radius_x", this.radiusX);
        tag.putInt("radius_z", this.radiusZ);
        tag.putLong("noise_seed", this.noiseSeed);
    }

    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pos) {
        int calderaCutoffY = pos.getY() + 194;
        int lavaY = pos.getY() + 149;
        int topY = pos.getY() + 187;
        int crustY = pos.getY() + 184;
        BlockPos corePos = new BlockPos(pos.getX(), level.getMinY() + 1, pos.getZ());
        if (chunkBox.isInside((Vec3i)corePos)) {
            level.setBlock(corePos, ((VolcanoBlock)((Object)TropicraftBlocks.VOLCANO.get())).defaultBlockState(), 2);
            BlockEntity blockEntity = level.getBlockEntity(corePos);
            if (blockEntity instanceof VolcanoBlockEntity) {
                VolcanoBlockEntity volcano = (VolcanoBlockEntity)blockEntity;
                volcano.setHeightOffset(pos.getY());
            }
        }
        for (int z = chunkBox.minZ(); z <= chunkBox.maxZ(); ++z) {
            for (int x = chunkBox.minX(); x <= chunkBox.maxX(); ++x) {
                float height = this.getColumnHeight(x - pos.getX(), z - pos.getZ());
                if (Float.isNaN(height)) continue;
                this.placeColumn(level, random, x, z, calderaCutoffY, lavaY, topY, crustY, height);
            }
        }
    }

    private void placeColumn(WorldGenLevel level, RandomSource random, int x, int z, int calderaCutoffY, int lavaY, int topY, int crustY, float height) {
        BlockState volcanoState = ((Block)TropicraftBlocks.CHUNK.get()).defaultBlockState();
        BlockState sandState = ((VolcanicSandBlock)((Object)TropicraftBlocks.VOLCANIC_SAND.get())).defaultBlockState();
        BlockState lavaState = Blocks.LAVA.defaultBlockState();
        BlockState airState = Blocks.AIR.defaultBlockState();
        int terrainY = Math.min(level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, x, z), lavaY - 3);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int y = level.getMaxY(); y > level.getMinY(); --y) {
            mutablePos.set(x, y, z);
            if (height + (float)terrainY < (float)calderaCutoffY) {
                if (height + (float)terrainY <= (float)topY) {
                    if (!((float)y <= height + (float)terrainY)) continue;
                    if (y > terrainY) {
                        level.setBlock((BlockPos)mutablePos, volcanoState, 2);
                        continue;
                    }
                    if (y <= terrainY - 2) continue;
                    level.setBlock((BlockPos)mutablePos, sandState, 2);
                    continue;
                }
                if (y == crustY - 1) {
                    if (random.nextInt(3) == 0) continue;
                    level.setBlock((BlockPos)mutablePos, volcanoState, 2);
                    continue;
                }
                if (y > topY) continue;
                level.setBlock((BlockPos)mutablePos, volcanoState, 2);
                continue;
            }
            if (y == crustY && random.nextInt(15) != 0) {
                level.setBlock((BlockPos)mutablePos, volcanoState, 2);
                continue;
            }
            if (y <= lavaY) {
                level.setBlock((BlockPos)mutablePos, lavaState, 2);
                continue;
            }
            level.setBlock((BlockPos)mutablePos, airState, 2);
        }
    }

    private float getColumnHeight(float x, float z) {
        float distanceSquared = (float)Mth.lengthSquared((double)(x / (float)this.radiusX), (double)(z / (float)this.radiusZ));
        if (distanceSquared >= 1.0f) {
            return Float.NaN;
        }
        float noiseValue = (float)Math.abs(this.noise.noise((double)x * 0.21 + 0.01, 0.0, (double)z * 0.21 + 0.01)) * 0.45f + 1.0f;
        return 10.2f / distanceSquared * noiseValue - 10.2f - 2.0f;
    }
}

