/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.drinks;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.common.TropicraftRegistries;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.DrinkIngredient;
import net.tropicraft.core.common.drinks.TropicraftDrinkIngredients;
import net.tropicraft.core.common.drinks.action.DrinkAction;
import net.tropicraft.core.common.drinks.action.PortalDrinkAction;
import net.tropicraft.core.common.drinks.action.PotionDrinkAction;
import net.tropicraft.core.common.entity.TropicraftEntities;

public interface TropicraftDrinks {
    public static final ResourceKey<Drink> LEMONADE = TropicraftDrinks.createKey("lemonade");
    public static final ResourceKey<Drink> LIMEADE = TropicraftDrinks.createKey("limeade");
    public static final ResourceKey<Drink> ORANGEADE = TropicraftDrinks.createKey("orangeade");
    public static final ResourceKey<Drink> CAIPIRINHA = TropicraftDrinks.createKey("caipirinha");
    public static final ResourceKey<Drink> BLACK_COFFEE = TropicraftDrinks.createKey("black_coffee");
    public static final ResourceKey<Drink> PINA_COLADA = TropicraftDrinks.createKey("pina_colada");
    public static final ResourceKey<Drink> COCONUT_WATER = TropicraftDrinks.createKey("coconut_water");
    public static final ResourceKey<Drink> MAI_TAI = TropicraftDrinks.createKey("mai_tai");

    public static void bootstrap(BootstrapContext<Drink> context) {
        HolderGetter ingredientLookup = context.lookup(TropicraftRegistries.DRINK_INGREDIENT);
        TropicraftDrinks.register(context, (HolderGetter<DrinkIngredient>)ingredientLookup, LEMONADE, (Component)TropicraftLangKeys.LEMONADE.component(ChatFormatting.YELLOW), 16440129, List.of(new PotionDrinkAction((Holder<MobEffect>)MobEffects.SPEED, 5, 1)), List.of(TropicraftDrinkIngredients.LEMON, TropicraftDrinkIngredients.SUGAR, TropicraftDrinkIngredients.WATER_BUCKET));
        TropicraftDrinks.register(context, (HolderGetter<DrinkIngredient>)ingredientLookup, LIMEADE, (Component)TropicraftLangKeys.LIMEADE.component(ChatFormatting.GREEN), 8710282, List.of(new PotionDrinkAction((Holder<MobEffect>)MobEffects.SPEED, 5, 1)), List.of(TropicraftDrinkIngredients.LIME, TropicraftDrinkIngredients.SUGAR, TropicraftDrinkIngredients.WATER_BUCKET));
        TropicraftDrinks.register(context, (HolderGetter<DrinkIngredient>)ingredientLookup, ORANGEADE, (Component)TropicraftLangKeys.ORANGEADE.component(ChatFormatting.GOLD), 15973942, List.of(new PotionDrinkAction((Holder<MobEffect>)MobEffects.SPEED, 5, 1)), List.of(TropicraftDrinkIngredients.ORANGE, TropicraftDrinkIngredients.SUGAR, TropicraftDrinkIngredients.WATER_BUCKET));
        TropicraftDrinks.register(context, (HolderGetter<DrinkIngredient>)ingredientLookup, CAIPIRINHA, (Component)TropicraftLangKeys.CAIPIRINHA.component(ChatFormatting.GREEN), 9764662, List.of(new PotionDrinkAction((Holder<MobEffect>)MobEffects.SPEED, 5, 1)), List.of(TropicraftDrinkIngredients.LIME, TropicraftDrinkIngredients.SUGAR_CANE, TropicraftDrinkIngredients.WATER_BUCKET));
        TropicraftDrinks.register(context, (HolderGetter<DrinkIngredient>)ingredientLookup, BLACK_COFFEE, (Component)TropicraftLangKeys.BLACK_COFFEE.component(ChatFormatting.WHITE), 6833196, List.of(new PotionDrinkAction((Holder<MobEffect>)MobEffects.REGENERATION, 5, 1), new PotionDrinkAction((Holder<MobEffect>)MobEffects.SPEED, 5, 2)), List.of(TropicraftDrinkIngredients.ROASTED_COFFEE_BEAN, TropicraftDrinkIngredients.WATER_BUCKET));
        TropicraftDrinks.register(context, (HolderGetter<DrinkIngredient>)ingredientLookup, PINA_COLADA, (Component)TropicraftLangKeys.PINA_COLADA.component(ChatFormatting.GOLD), 0xEFEFEF, List.of(new PotionDrinkAction((Holder<MobEffect>)MobEffects.NAUSEA, 10, 0), new PortalDrinkAction(TropicraftDimension.WORLD, Optional.of(HolderSet.direct((Holder[])new Holder[]{TropicraftEntities.CHAIR})), 12200, 14000)), List.of(TropicraftDrinkIngredients.PINEAPPLE, TropicraftDrinkIngredients.COCONUT));
        TropicraftDrinks.register(context, (HolderGetter<DrinkIngredient>)ingredientLookup, COCONUT_WATER, (Component)TropicraftLangKeys.COCONUT_WATER.component(ChatFormatting.WHITE), 0xDFDFDF, List.of(new PotionDrinkAction((Holder<MobEffect>)MobEffects.SPEED, 5, 1)), List.of(TropicraftDrinkIngredients.COCONUT, TropicraftDrinkIngredients.WATER_BUCKET));
        TropicraftDrinks.register(context, (HolderGetter<DrinkIngredient>)ingredientLookup, MAI_TAI, (Component)TropicraftLangKeys.MAI_TAI.component(ChatFormatting.GOLD), 16742190, List.of(new PotionDrinkAction((Holder<MobEffect>)MobEffects.NAUSEA, 5, 0)), List.of(TropicraftDrinkIngredients.ORANGE, TropicraftDrinkIngredients.LIME, TropicraftDrinkIngredients.WATER_BUCKET));
    }

    public static void register(BootstrapContext<Drink> context, HolderGetter<DrinkIngredient> ingredientLookup, ResourceKey<Drink> key, Component name, int color, List<DrinkAction> actions, List<ResourceKey<DrinkIngredient>> ingredients) {
        context.register(key, (Object)new Drink(name, color, actions, ingredients.stream().map(arg_0 -> ingredientLookup.getOrThrow(arg_0)).collect(Collectors.toUnmodifiableList())));
    }

    public static ResourceKey<Drink> createKey(String name) {
        return Tropicraft.resourceKey(TropicraftRegistries.DRINK, name);
    }
}

