/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity;

import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.egg.SeaTurtleEggEntity;
import org.jetbrains.annotations.Nullable;

public class SeaTurtleEntity
extends Turtle {
    private static final EntityDataAccessor<Boolean> IS_MATURE = SynchedEntityData.defineId(SeaTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TURTLE_TYPE = SynchedEntityData.defineId(SeaTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> NO_BRAKES = SynchedEntityData.defineId(SeaTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CAN_FLY = SynchedEntityData.defineId(SeaTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_DIGGING = SynchedEntityData.defineId(SeaTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.defineId(SeaTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int NUM_TYPES = 6;
    private double lastPosY;
    private int digCounter;
    private float swimSpeedCurrent;

    public SeaTurtleEntity(EntityType<? extends Turtle> type, Level world) {
        super(type, world);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setRandomTurtleType();
        this.lastPosY = this.getY();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    protected void registerGoals() {
        Optional<WrappedGoal> mateGoal;
        super.registerGoals();
        Set goalSet = this.goalSelector.getAvailableGoals();
        Optional<WrappedGoal> eggGoal = goalSet.stream().filter(p -> p.getGoal().toString().contains("Egg")).findFirst();
        if (eggGoal.isPresent()) {
            this.goalSelector.removeGoal(eggGoal.get().getGoal());
            this.goalSelector.addGoal(1, (Goal)new BetterLayEggGoal(this, 1.0));
        }
        if ((mateGoal = goalSet.stream().filter(p -> p.getGoal().toString().contains("Mate")).findFirst()).isPresent()) {
            this.goalSelector.removeGoal(mateGoal.get().getGoal());
            this.goalSelector.addGoal(1, (Goal)new BetterMateGoal(this, 1.0));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_MATURE, (Object)true);
        builder.define(TURTLE_TYPE, (Object)1);
        builder.define(NO_BRAKES, (Object)false);
        builder.define(CAN_FLY, (Object)false);
        builder.define(IS_DIGGING, (Object)false);
        builder.define(HAS_EGG, (Object)false);
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putInt("TurtleType", this.getTurtleType());
        output.putBoolean("IsMature", this.isMature());
        output.putBoolean("NoBrakesOnThisTrain", this.getNoBrakes());
        output.putBoolean("LongsForTheSky", this.getCanFly());
        output.putBoolean("HasEgg", this.hasEgg());
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        input.getInt("TurtleType").ifPresentOrElse(this::setTurtleType, this::setRandomTurtleType);
        this.setIsMature(input.getBooleanOr("IsMature", true));
        this.setNoBrakes(input.getBooleanOr("NoBrakesOnThisTrain", false));
        this.setCanFly(input.getBooleanOr("LongsForTheSky", false));
        this.setHasEgg(input.getBooleanOr("HasEgg", false));
        this.lastPosY = this.getY();
    }

    public boolean isMature() {
        return (Boolean)this.getEntityData().get(IS_MATURE);
    }

    public SeaTurtleEntity setIsMature(boolean mature) {
        this.getEntityData().set(IS_MATURE, (Object)mature);
        return this;
    }

    public int getTurtleType() {
        return (Integer)this.getEntityData().get(TURTLE_TYPE);
    }

    public void setRandomTurtleType() {
        this.setTurtleType(this.random.nextInt(6) + 1);
    }

    public SeaTurtleEntity setTurtleType(int type) {
        this.getEntityData().set(TURTLE_TYPE, (Object)Mth.clamp((int)type, (int)1, (int)6));
        return this;
    }

    public boolean getNoBrakes() {
        return (Boolean)this.getEntityData().get(NO_BRAKES);
    }

    public SeaTurtleEntity setNoBrakes(boolean noBrakes) {
        this.getEntityData().set(NO_BRAKES, (Object)noBrakes);
        return this;
    }

    public boolean getCanFly() {
        return (Boolean)this.getEntityData().get(CAN_FLY);
    }

    public SeaTurtleEntity setCanFly(boolean canFly) {
        this.getEntityData().set(CAN_FLY, (Object)canFly);
        return this;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity living;
        Entity entity = this.getFirstPassenger();
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    public static boolean canSpawnOnLand(EntityType<SeaTurtleEntity> turtle, LevelAccessor world, EntitySpawnReason reason, BlockPos pos, RandomSource rand) {
        return pos.getY() < TropicraftDimension.getSeaLevel((LevelReader)world) + 4 && world.getBlockState(pos.below()).is(Blocks.SAND) && world.getRawBrightness(pos, 0) > 8;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob partner) {
        return ((SeaTurtleEntity)((EntityType)TropicraftEntities.SEA_TURTLE.get()).create(this.level(), EntitySpawnReason.BREEDING)).setTurtleType(this.random.nextBoolean() && partner instanceof SeaTurtleEntity ? ((SeaTurtleEntity)partner).getTurtleType() : this.getTurtleType()).setIsMature(false);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult result = super.mobInteract(player, hand);
        if (result != InteractionResult.PASS) {
            return result;
        }
        if (!this.level().isClientSide && !player.isShiftKeyDown() && this.canAddPassenger((Entity)player) && this.isMature()) {
            player.startRiding((Entity)this);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean shouldRender(double x, double y, double z) {
        LivingEntity controller = this.getControllingPassenger();
        if (controller != null) {
            return controller.shouldRender(x, y, z);
        }
        return super.shouldRender(x, y, z);
    }

    public void tick() {
        super.tick();
        this.lastPosY = this.getY();
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive() && this.isLayingEgg() && this.digCounter >= 1 && this.digCounter % 5 == 0) {
            BlockPos pos = this.blockPosition();
            if (this.level().getBlockState(pos.below()).is(BlockTags.SAND)) {
                this.level().levelEvent(2001, pos, Block.getId((BlockState)Blocks.SAND.defaultBlockState()));
            }
        }
        if (this.level().isClientSide && this.isVehicle() && this.hasControllingPassenger() && (this.isInWater() || this.getCanFly())) {
            Vec3 movement = new Vec3(this.getX(), this.getY(), this.getZ()).subtract(this.xo, this.yo, this.zo);
            double speed = movement.length();
            Vec3 particleOffset = movement.reverse().scale(2.0);
            if (speed > 0.05) {
                int maxParticles = Mth.ceil((double)(speed * 5.0));
                int particlesToSpawn = this.random.nextInt(1 + maxParticles);
                SimpleParticleType particle = this.isInWater() ? ParticleTypes.BUBBLE : ParticleTypes.END_ROD;
                for (int i = 0; i < particlesToSpawn; ++i) {
                    Vec3 particleMotion = movement.scale(1.0);
                    this.level().addParticle((ParticleOptions)particle, true, true, particleOffset.x() + this.getX() - 0.25 + this.random.nextDouble() * 0.5, particleOffset.y() + this.getY() + 0.1 + this.random.nextDouble() * 0.1, particleOffset.z() + this.getZ() - 0.25 + this.random.nextDouble() * 0.5, particleMotion.x, particleMotion.y, particleMotion.z);
                }
            }
        }
    }

    public float lerp(float x1, float x2, float t) {
        return x1 + t * 0.03f * Mth.wrapDegrees((float)(x2 - x1));
    }

    public void positionRider(Entity passenger, Entity.MoveFunction function) {
        super.positionRider(passenger, function);
        if (this.hasPassenger(passenger)) {
            if (passenger instanceof Player) {
                Player p = (Player)passenger;
                if (this.isInWater()) {
                    if (p.zza > 0.0f) {
                        this.setXRot(this.lerp(this.getXRot(), -(passenger.getXRot() * 0.5f), 6.0f));
                        this.setYRot(this.lerp(this.getYRot(), -passenger.getYRot(), 6.0f));
                        this.swimSpeedCurrent += 0.05f;
                        if (this.swimSpeedCurrent > 4.0f) {
                            this.swimSpeedCurrent = 4.0f;
                        }
                    }
                    if (p.zza < 0.0f) {
                        this.swimSpeedCurrent *= 0.89f;
                        if (this.swimSpeedCurrent < 0.1f) {
                            this.swimSpeedCurrent = 0.1f;
                        }
                    }
                    if (p.zza == 0.0f) {
                        if (this.swimSpeedCurrent > 1.0f) {
                            this.swimSpeedCurrent *= 0.94f;
                            if (this.swimSpeedCurrent <= 1.0f) {
                                this.swimSpeedCurrent = 1.0f;
                            }
                        }
                        if (this.swimSpeedCurrent < 1.0f) {
                            this.swimSpeedCurrent *= 1.06f;
                            if (this.swimSpeedCurrent >= 1.0f) {
                                this.swimSpeedCurrent = 1.0f;
                            }
                        }
                    }
                }
            } else if (passenger instanceof Mob) {
                Mob mobentity = (Mob)passenger;
                this.yBodyRot = mobentity.yBodyRot;
                this.yHeadRotO = mobentity.yHeadRotO;
            }
        }
    }

    protected void tickRidden(Player player, Vec3 input) {
        super.tickRidden(player, input);
        this.setRot(player.getYRot(), player.getXRot());
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        if (!this.isInWater()) {
            double gravity = this.getGravity();
            if (this.getCanFly()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -gravity * 0.05, 0.0));
            } else {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.9, 0.99, 0.9).add(0.0, -gravity, 0.0));
            }
        }
        if (!this.canSimulateMovement()) {
            this.fallDistance = (float)Math.max(0.0, (this.getY() - this.lastPosY) * -8.0);
        }
    }

    protected Vec3 getRiddenInput(Player player, Vec3 mobInput) {
        double strafe = player.xxa;
        double forward = this.getNoBrakes() ? 1.0 : (double)player.zza;
        double vertical = -Math.sin(Math.toRadians(this.getXRot())) * forward;
        return new Vec3(strafe, vertical + (double)player.yya, forward *= Mth.clamp((double)(1.0 - (double)Math.abs(this.getXRot()) / 90.0), (double)0.01, (double)1.0));
    }

    public void travel(Vec3 input) {
        if (this.hasControllingPassenger()) {
            Vec3 travel = input.scale(this.getAttribute(Attributes.MOVEMENT_SPEED).getValue()).scale((double)0.025f);
            this.moveRelative(1.0f, travel);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(input.z > 0.0 || !this.isInWater() ? 0.975 : 0.9));
            this.calculateEntityAnimation(true);
            return;
        }
        super.travel(input);
    }

    protected float getFlyingSpeed() {
        LivingEntity passenger = this.getControllingPassenger();
        return passenger != null ? this.getSpeed() * 0.1f : 0.02f;
    }

    private void setDigging(boolean digging) {
        this.digCounter = digging ? 1 : 0;
        this.entityData.set(IS_DIGGING, (Object)digging);
    }

    public boolean isLayingEgg() {
        return this.digCounter > 0;
    }

    private void setHasEgg(boolean hasEgg) {
        this.entityData.set(HAS_EGG, (Object)hasEgg);
    }

    public boolean hasEgg() {
        return (Boolean)this.entityData.get(HAS_EGG);
    }

    static class BetterLayEggGoal
    extends MoveToBlockGoal {
        private final SeaTurtleEntity turtle;

        BetterLayEggGoal(SeaTurtleEntity turtle, double speedIn) {
            super((PathfinderMob)turtle, speedIn, 16);
            this.turtle = turtle;
        }

        public boolean canUse() {
            return this.turtle.hasEgg() && this.turtle.getHomePosition().closerToCenterThan((Position)this.turtle.position(), 9.0) && super.canUse();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.turtle.hasEgg() && this.turtle.getHomePosition().closerToCenterThan((Position)this.turtle.position(), 9.0);
        }

        public void tick() {
            super.tick();
            BlockPos blockpos = this.turtle.blockPosition();
            if (!this.turtle.isInWater() && this.isReachedTarget()) {
                if (!this.turtle.isLayingEgg()) {
                    this.turtle.setDigging(true);
                } else if (this.turtle.digCounter > 200) {
                    Level world = this.turtle.level();
                    world.playSound(null, blockpos, SoundEvents.TURTLE_LAY_EGG, SoundSource.BLOCKS, 0.3f, 0.9f + world.random.nextFloat() * 0.2f);
                    SeaTurtleEggEntity egg = (SeaTurtleEggEntity)((EntityType)TropicraftEntities.SEA_TURTLE_EGG.get()).create(world, EntitySpawnReason.BREEDING);
                    BlockPos spawnPos = this.blockPos.above();
                    egg.setPos(spawnPos.getX(), spawnPos.getY(), spawnPos.getZ());
                    world.addFreshEntity((Entity)egg);
                    this.turtle.setHasEgg(false);
                    this.turtle.setDigging(false);
                    this.turtle.setInLoveTime(600);
                }
                if (this.turtle.isLayingEgg()) {
                    ++this.turtle.digCounter;
                }
            }
        }

        protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
            if (!worldIn.isEmptyBlock(pos.above())) {
                return false;
            }
            return worldIn.getBlockState(pos).is(BlockTags.SAND);
        }
    }

    static class BetterMateGoal
    extends BreedGoal {
        private final SeaTurtleEntity turtle;

        BetterMateGoal(SeaTurtleEntity turtle, double speedIn) {
            super((Animal)turtle, speedIn);
            this.turtle = turtle;
        }

        public boolean canUse() {
            return super.canUse() && !this.turtle.hasEgg();
        }

        protected void breed() {
            ServerPlayer serverplayerentity = this.animal.getLoveCause();
            if (serverplayerentity == null && this.partner.getLoveCause() != null) {
                serverplayerentity = this.partner.getLoveCause();
            }
            if (serverplayerentity != null) {
                serverplayerentity.awardStat(Stats.ANIMALS_BRED);
                CriteriaTriggers.BRED_ANIMALS.trigger(serverplayerentity, this.animal, this.partner, null);
            }
            this.turtle.setHasEgg(true);
            this.animal.resetLove();
            this.partner.resetLove();
            RandomSource random = this.animal.getRandom();
            if (this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                this.level.addFreshEntity((Entity)new ExperienceOrb((Level)this.level, this.animal.getX(), this.animal.getY(), this.animal.getZ(), random.nextInt(7) + 1));
            }
        }
    }
}

