/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.TropicraftTags;

public class BirdWanderInTreesGoal
extends RandomStrollGoal {
    private static final int INTERVAL = 80;
    private static final int MIN_RANGE = 3;
    private static final int MAX_HORIZONTAL_RANGE = 4;
    private static final int MAX_VERTICAL_RANGE = 6;

    public BirdWanderInTreesGoal(PathfinderMob mob, double speed) {
        super(mob, speed, 80);
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, 0, this.speedModifier);
    }

    @Nullable
    protected Vec3 getPosition() {
        float treeChance;
        Vec3 target;
        if (this.mob.isInWater() && (target = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)15)) != null) {
            return target;
        }
        float f = treeChance = this.mob.getBlockStateOn().is(TropicraftTags.Blocks.BIRDS_LIKE_TO_STAND_ON) ? 0.95f : 0.5f;
        if (this.mob.getRandom().nextFloat() < treeChance) {
            return this.findTreePos();
        }
        return LandRandomPos.getPos((PathfinderMob)this.mob, (int)5, (int)5);
    }

    @Nullable
    private Vec3 findTreePos() {
        Level level = this.mob.level();
        BlockPos origin = this.mob.blockPosition();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        return BlockPos.findClosestMatch((BlockPos)origin, (int)4, (int)6, pos -> {
            if (pos.distManhattan((Vec3i)origin) < 3) {
                return false;
            }
            if (BirdWanderInTreesGoal.wantsToStandAt(pos, level, mutablePos)) {
                return this.mob.getRandom().nextInt(7) != 0;
            }
            return false;
        }).map(Vec3::atBottomCenterOf).orElse(null);
    }

    private static boolean wantsToStandAt(BlockPos pos, Level level, BlockPos.MutableBlockPos mutablePos) {
        BlockState belowState = level.getBlockState((BlockPos)mutablePos.setWithOffset((Vec3i)pos, Direction.DOWN));
        if (belowState.is(TropicraftTags.Blocks.BIRDS_LIKE_TO_STAND_ON)) {
            BlockPos.MutableBlockPos abovePos = mutablePos.setWithOffset((Vec3i)pos, Direction.UP);
            return level.isEmptyBlock(pos) && level.isEmptyBlock((BlockPos)abovePos);
        }
        return false;
    }
}

