/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class EntityAIAvoidEntityOnLowHealth<T extends Entity>
extends Goal {
    private final Predicate<Entity> canBeSeenSelector = entity -> entity.isAlive() && this.theEntity.getSensing().hasLineOfSight(entity);
    protected PathfinderMob theEntity;
    private final double farSpeed;
    private final double nearSpeed;
    @Nullable
    protected T closestLivingEntity;
    private final float avoidDistance;
    @Nullable
    private Path entityPathEntity;
    private final PathNavigation entityPathNavigate;
    private final Class<T> classToAvoid;
    private final Predicate<Entity> avoidTargetSelector;
    private float healthToAvoid = 0.0f;

    public EntityAIAvoidEntityOnLowHealth(PathfinderMob theEntityIn, Class<T> classToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn, float healthToAvoid) {
        this(theEntityIn, classToAvoidIn, entity -> true, avoidDistanceIn, farSpeedIn, nearSpeedIn, healthToAvoid);
    }

    public EntityAIAvoidEntityOnLowHealth(PathfinderMob theEntityIn, Class<T> classToAvoidIn, Predicate<Entity> avoidTargetSelectorIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn, float healthToAvoid) {
        this.theEntity = theEntityIn;
        this.classToAvoid = classToAvoidIn;
        this.avoidTargetSelector = avoidTargetSelectorIn;
        this.avoidDistance = avoidDistanceIn;
        this.farSpeed = farSpeedIn;
        this.nearSpeed = nearSpeedIn;
        this.entityPathNavigate = theEntityIn.getNavigation();
        this.healthToAvoid = healthToAvoid;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.theEntity.getHealth() > this.healthToAvoid) {
            return false;
        }
        List list = this.theEntity.level().getEntitiesOfClass(this.classToAvoid, this.theEntity.getBoundingBox().expandTowards((double)this.avoidDistance, 3.0, (double)this.avoidDistance), EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(this.canBeSeenSelector).and(this.avoidTargetSelector));
        if (list.isEmpty()) {
            return false;
        }
        this.closestLivingEntity = (Entity)list.getFirst();
        Vec3 Vector3d = DefaultRandomPos.getPosAway((PathfinderMob)this.theEntity, (int)16, (int)7, (Vec3)new Vec3(this.closestLivingEntity.getX(), this.closestLivingEntity.getY(), this.closestLivingEntity.getZ()));
        if (Vector3d == null) {
            return false;
        }
        if (this.closestLivingEntity.distanceToSqr(Vector3d.x, Vector3d.y, Vector3d.z) < this.closestLivingEntity.distanceToSqr((Entity)this.theEntity)) {
            return false;
        }
        this.entityPathEntity = this.entityPathNavigate.createPath(Vector3d.x, Vector3d.y, Vector3d.z, 0);
        return this.entityPathEntity != null;
    }

    public boolean canContinueToUse() {
        return this.entityPathNavigate.isInProgress();
    }

    public void start() {
        this.entityPathNavigate.moveTo(this.entityPathEntity, this.farSpeed);
    }

    public void stop() {
        this.closestLivingEntity = null;
    }

    public void tick() {
        if (this.theEntity.distanceToSqr(this.closestLivingEntity) < 49.0) {
            this.theEntity.getNavigation().setSpeedModifier(this.nearSpeed);
        } else {
            this.theEntity.getNavigation().setSpeedModifier(this.farSpeed);
        }
    }
}

