/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class EntityAIEatToHeal
extends Goal {
    private final EntityKoaBase entityObj;
    private final int walkingTimeoutMax = 200;
    private int walkingTimeout;
    private int repathPentalty = 0;
    private int lookUpdateTimer = 0;
    private final int randXPos = 0;
    private final int randYPos = 0;
    private final int randZPos = 0;
    private final float missingHealthToHeal = 5.0f;

    public EntityAIEatToHeal(EntityKoaBase entityObjIn) {
        this.entityObj = entityObjIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.entityObj.getHealth() < this.entityObj.getMaxHealth() - 5.0f) {
            return this.hasFoodSource();
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void tick() {
        super.tick();
        if (this.hasFoodSource((Container)this.entityObj.inventory)) {
            this.consumeOneStackSizeOfFood((Container)this.entityObj.inventory);
            this.entityObj.heal(5.0f);
            this.entityObj.level().playSound(null, this.entityObj.blockPosition(), SoundEvents.PLAYER_BURP, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return;
        }
        if (this.hasFoodAtHome()) {
            boolean isClose = false;
            BlockPos blockposGoal = this.entityObj.getHomePosition();
            if (blockposGoal.equals((Object)BlockPos.ZERO)) {
                this.stop();
                return;
            }
            double dist = this.entityObj.position().distanceTo(new Vec3((double)blockposGoal.getX(), (double)blockposGoal.getY(), (double)blockposGoal.getZ()));
            if (dist < 5.0) {
                this.consumeOneStackSizeOfFoodAtHome();
                this.entityObj.heal(5.0f);
                this.entityObj.level().playSound(null, this.entityObj.blockPosition(), SoundEvents.PLAYER_BURP, SoundSource.NEUTRAL, 1.0f, 1.0f);
                return;
            }
            if (!isClose) {
                if ((this.entityObj.getNavigation().isDone() || this.walkingTimeout <= 0) && this.repathPentalty <= 0) {
                    int i = blockposGoal.getX();
                    int j = blockposGoal.getY();
                    int k = blockposGoal.getZ();
                    boolean success = false;
                    if (this.entityObj.distanceToSqr(Vec3.atCenterOf((Vec3i)blockposGoal)) > 256.0) {
                        Vec3 Vector3d = DefaultRandomPos.getPosTowards((PathfinderMob)this.entityObj, (int)14, (int)3, (Vec3)new Vec3((double)i + 0.5, (double)j, (double)k + 0.5), (double)1.5707963705062866);
                        if (Vector3d != null) {
                            success = this.entityObj.getNavigation().moveTo(Vector3d.x, Vector3d.y, Vector3d.z, 1.0);
                        }
                    } else {
                        success = this.entityObj.getNavigation().moveTo((double)i + 0.5, (double)j, (double)k + 0.5, 1.0);
                    }
                    if (!success) {
                        this.repathPentalty = 40;
                    } else {
                        this.walkingTimeout = 200;
                    }
                } else if (this.walkingTimeout > 0) {
                    --this.walkingTimeout;
                }
            }
            if (this.repathPentalty > 0) {
                --this.repathPentalty;
            }
            if (this.lookUpdateTimer > 0) {
                --this.lookUpdateTimer;
            }
        }
    }

    public void start() {
        super.start();
        this.entityObj.getNavigation().stop();
    }

    public void stop() {
        super.stop();
        this.entityObj.setSitting(false);
        this.walkingTimeout = 0;
    }

    public boolean isTooClose() {
        BlockPos blockposGoal = null;
        if (this.entityObj.posLastFireplaceFound != null) {
            blockposGoal = this.entityObj.posLastFireplaceFound.offset(0, -1, 0);
        } else {
            if (!this.entityObj.hasHome()) {
                return false;
            }
            blockposGoal = this.entityObj.getHomePosition();
        }
        return this.entityObj.position().closerThan((Position)Vec3.atCenterOf((Vec3i)blockposGoal), 3.0);
    }

    public boolean hasFoodSource() {
        if (this.hasFoodSource((Container)this.entityObj.inventory)) {
            return true;
        }
        return this.hasFoodAtHome();
    }

    public boolean hasFoodAtHome() {
        if (this.entityObj.hasHome()) {
            ChestBlockEntity chest;
            BlockPos blockposGoal = this.entityObj.getHomePosition();
            BlockEntity tile = this.entityObj.level().getBlockEntity(blockposGoal);
            if (tile instanceof ChestBlockEntity && this.hasFoodSource((Container)(chest = (ChestBlockEntity)tile))) {
                return true;
            }
        }
        return false;
    }

    public boolean hasFoodSource(Container inv) {
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            if (!inv.getItem(i).has(DataComponents.FOOD)) continue;
            return true;
        }
        return false;
    }

    public ItemStack consumeOneStackSizeOfFoodAtHome() {
        if (this.entityObj.hasHome()) {
            BlockPos blockposGoal = this.entityObj.getHomePosition();
            BlockEntity tile = this.entityObj.level().getBlockEntity(blockposGoal);
            if (tile instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)tile;
                return this.consumeOneStackSizeOfFood((Container)chest);
            }
        }
        return ItemStack.EMPTY;
    }

    public ItemStack consumeOneStackSizeOfFood(Container inv) {
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !stack.has(DataComponents.FOOD)) continue;
            ItemStack newStack = stack.split(1);
            if (stack.getCount() <= 0) {
                inv.setItem(i, ItemStack.EMPTY);
            }
            return newStack;
        }
        return ItemStack.EMPTY;
    }
}

