/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.fishies;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.underdasea.TropicraftFishEntity;

public class AvoidWallsGoal
extends Goal {
    public final TropicraftFishEntity entity;
    public final RandomSource rand;

    public AvoidWallsGoal(EnumSet<Goal.Flag> flags, TropicraftFishEntity entityObjIn) {
        this.entity = entityObjIn;
        this.rand = this.entity.getRandom();
        this.setFlags(flags);
    }

    public boolean canUse() {
        return this.entity.isInWater();
    }

    public void tick() {
        super.tick();
        Vec3 angle = this.entity.getHeading();
        double frontDist = 1 + this.rand.nextInt(4);
        Vec3 diff = new Vec3(this.entity.getX() + angle.x * frontDist, this.entity.getY() + angle.y, this.entity.getZ() + angle.z * frontDist);
        BlockPos bp = new BlockPos((int)diff.x, (int)this.entity.getY(), (int)diff.z);
        if (!this.entity.level().getBlockState(bp).liquid() && !this.entity.isMovingAwayFromWall) {
            this.entity.setRandomTargetHeadingForce(32);
            this.entity.isMovingAwayFromWall = true;
        }
        if (this.entity.tickCount % 20 == 0 && this.entity.isMovingAwayFromWall) {
            this.entity.isMovingAwayFromWall = false;
        }
        if (this.entity.targetVector != null && this.entity.isMovingAwayFromWall) {
            bp = new BlockPos((int)this.entity.targetVector.x, (int)this.entity.targetVector.y, (int)this.entity.targetVector.z);
            if (this.entity.blockPosition().equals((Object)bp) && this.entity.tickCount % 80 == 0) {
                this.entity.isMovingAwayFromWall = false;
            }
        }
        bp = this.entity.blockPosition();
        if (!this.entity.level().getBlockState(bp).liquid() && this.entity.swimPitch > 0.0f) {
            this.entity.isPanicking = false;
            this.entity.setRandomTargetHeadingForce(32);
        }
        bp = new BlockPos((Vec3i)this.entity.blockPosition().below(2));
        if (!this.entity.level().getBlockState(bp).liquid() && this.entity.swimPitch < 0.0f) {
            this.entity.swimPitch += 2.0f;
        }
    }

    public boolean canContinueToUse() {
        return this.entity.isInWater();
    }
}

