/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.fishies;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.tropicraft.core.common.entity.underdasea.TropicraftFishEntity;

public class SwimToAvoidEntityGoal
extends Goal {
    public final TropicraftFishEntity entity;
    public final RandomSource rand;
    public final Class<? extends Entity>[] entityClassToAvoid;
    public final double distanceToAvoid;

    public SwimToAvoidEntityGoal(EnumSet<Goal.Flag> flags, TropicraftFishEntity entityObjIn, double dist, Class<? extends Entity>[] classes) {
        this.entity = entityObjIn;
        this.rand = this.entity.getRandom();
        this.entityClassToAvoid = classes;
        this.distanceToAvoid = dist;
        this.setFlags(flags);
    }

    public boolean canUse() {
        return this.entity.isInWater();
    }

    public void tick() {
        super.tick();
        List ents = this.entity.level().getEntities((Entity)this.entity, this.entity.getBoundingBox().inflate(this.distanceToAvoid));
        List<Class<? extends Entity>> classes = Arrays.asList(this.entityClassToAvoid);
        for (Entity ent : ents) {
            if (!classes.contains(ent.getClass())) continue;
            this.entity.fleeEntity(ent);
            break;
        }
    }

    public boolean canContinueToUse() {
        return this.entity.isInWater();
    }
}

