/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.fishies;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;
import net.tropicraft.core.common.entity.underdasea.TropicraftFishEntity;

public class TargetPreyGoal
extends Goal {
    public final TropicraftFishEntity entity;
    public final RandomSource rand;

    public TargetPreyGoal(EnumSet<Goal.Flag> flags, TropicraftFishEntity entityObjIn) {
        this.entity = entityObjIn;
        this.rand = this.entity.getRandom();
        this.setFlags(flags);
    }

    public boolean canUse() {
        if (this.entity.isInWater()) {
            Objects.requireNonNull(this.entity);
        }
        return false;
    }

    public void tick() {
        List list;
        super.tick();
        AABB entityBB = this.entity.getBoundingBox();
        if ((this.entity.tickCount % 80 == 0 && this.entity.aggressTarget == null || this.entity.level().getEntity(this.entity.aggressTarget.getId()) == null) && !(list = this.entity.level().getEntities((Entity)this.entity, entityBB.inflate(20.0, 20.0, 20.0).move(0.0, -8.0, 0.0), e -> e.isAlive())).isEmpty()) {
            Entity ent = (Entity)list.get(this.rand.nextInt(list.size()));
            boolean skip = false;
            if (ent.equals((Object)this.entity)) {
                skip = true;
            }
            if (ent.getClass().getName().equals(((Object)((Object)this.entity)).getClass().getName())) {
                skip = true;
            }
            if (!ent.isInWater()) {
                skip = true;
            }
            if (!this.entity.hasLineOfSight(ent)) {
                skip = true;
            }
            if (!skip && ent instanceof LivingEntity && ent.isInWater()) {
                this.entity.aggressTarget = ent;
            }
        }
        if (this.rand.nextInt(200) == 0) {
            this.entity.aggressTarget = null;
            this.entity.setRandomTargetHeading();
        }
        if (this.entity.aggressTarget != null) {
            if (this.entity.distanceToSqr(this.entity.aggressTarget) <= (double)this.entity.getBbWidth()) {
                if (this.entity.aggressTarget instanceof LivingEntity) {
                    this.entity.aggressTarget.hurt(this.entity.damageSources().mobAttack((LivingEntity)this.entity), (float)this.entity.getAttribute(Attributes.ATTACK_DAMAGE).getValue());
                }
                if (this.entity.aggressTarget instanceof TropicraftFishEntity) {
                    AABB aggressBB = this.entity.aggressTarget.getBoundingBox();
                    if (entityBB.maxY - entityBB.minY > aggressBB.maxY - aggressBB.minY) {
                        this.entity.aggressTarget.remove(Entity.RemovalReason.KILLED);
                        this.entity.heal(1.0f);
                        ++this.entity.eatenFishAmount;
                    }
                }
                this.entity.setRandomTargetHeading();
            } else if (this.entity.hasLineOfSight(this.entity.aggressTarget) && this.entity.tickCount % 20 == 0) {
                this.entity.setTargetHeading(this.entity.aggressTarget.getX(), this.entity.aggressTarget.getY(), this.entity.aggressTarget.getZ(), true);
            }
            if (!(this.entity.aggressTarget == null || this.entity.hasLineOfSight(this.entity.aggressTarget) && this.entity.aggressTarget.isInWater())) {
                this.entity.aggressTarget = null;
                this.entity.setRandomTargetHeading();
            }
        }
        if (this.entity.aggressTarget == null || this.entity.level().getEntity(this.entity.aggressTarget.getId()) == null || !this.entity.aggressTarget.isAlive()) {
            this.entity.aggressTarget = null;
            this.entity.setRandomTargetHeading();
        }
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }
}

