/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.vmonkey;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class MonkeyAngryThrowGoal
extends Goal {
    private final VMonkeyEntity entity;
    private final float speedModifier;
    private final float stopDistance;
    private final PathNavigation navigation;
    private float oldWaterCost;
    private int timeToRecalcPath;
    private int madMeter;
    @Nullable
    private ItemEntity trackedMug;
    @Nullable
    private LivingEntity trackedPlayer;

    public MonkeyAngryThrowGoal(VMonkeyEntity monkeyEntity) {
        this.entity = monkeyEntity;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.speedModifier = 1.2f;
        this.stopDistance = 1.0f;
        this.navigation = monkeyEntity.getNavigation();
    }

    public void stop() {
        this.navigation.stop();
        this.madMeter = 0;
        this.entity.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        this.trackedMug = null;
        this.trackedPlayer = null;
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.madMeter = 100;
        this.oldWaterCost = this.entity.getPathfindingMalus(PathType.WATER);
        this.entity.setPathfindingMalus(PathType.WATER, 0.0f);
        this.trackedMug = null;
        this.trackedPlayer = null;
    }

    public boolean canUse() {
        return !this.entity.isTame() && !this.entity.isLeashed() && this.entity.isMadAboutStolenAlcohol();
    }

    public boolean canContinueToUse() {
        return !this.entity.isTame() && !this.entity.isLeashed() && this.entity.isMadAboutStolenAlcohol();
    }

    public void tick() {
        if (this.trackedMug != null && this.entity.getMainHandItem().getItem() == ((Item)TropicraftItems.BAMBOO_MUG.get()).asItem()) {
            this.trackedPlayer = this.nearbyPlayer();
            if (this.trackedPlayer != null) {
                this.entity.getLookControl().setLookAt((Entity)this.trackedPlayer, 10.0f, (float)this.entity.getMaxHeadXRot());
                if (this.entity.distanceToSqr((Entity)this.trackedPlayer) < 4.0) {
                    this.leapTowardTarget(this.trackedPlayer);
                    this.entity.spawnAtLocation(MonkeyAngryThrowGoal.getServerLevel((Entity)this.entity), this.entity.getMainHandItem());
                    this.entity.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    this.entity.setMadAboutStolenAlcohol(false);
                } else {
                    this.moveTowardsEntity((Entity)this.trackedPlayer);
                }
            }
            return;
        }
        if (this.trackedMug != null && this.trackedMug.isAlive()) {
            this.entity.getLookControl().setLookAt((Entity)this.trackedMug, 10.0f, (float)this.entity.getMaxHeadXRot());
            if (this.entity.distanceToSqr((Entity)this.trackedMug) > (double)(this.stopDistance * this.stopDistance)) {
                this.moveTowardsEntity((Entity)this.trackedMug);
            } else {
                this.entity.setItemInHand(InteractionHand.MAIN_HAND, this.trackedMug.getItem());
                this.trackedMug.remove(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        if (--this.madMeter <= 0) {
            this.entity.setMadAboutStolenAlcohol(false);
            return;
        }
        this.trackedMug = this.nearbyMug();
    }

    @Nullable
    private LivingEntity nearbyPlayer() {
        List list = this.entity.level().getEntitiesOfClass(Player.class, this.entity.getBoundingBox().inflate(20.0));
        if (!list.isEmpty()) {
            for (Player entityliving : list) {
                if (entityliving.isInvisible()) continue;
                return entityliving;
            }
        }
        return null;
    }

    private void moveTowardsEntity(Entity itemEntity) {
        if (--this.timeToRecalcPath <= 0) {
            double d2;
            double d1;
            this.timeToRecalcPath = 10;
            double d0 = this.entity.getX() - itemEntity.getX();
            double d3 = d0 * d0 + (d1 = this.entity.getY() - itemEntity.getY()) * d1 + (d2 = this.entity.getZ() - itemEntity.getZ()) * d2;
            if (d3 > (double)(this.stopDistance * this.stopDistance)) {
                this.navigation.moveTo(itemEntity, (double)this.speedModifier);
            } else {
                this.navigation.stop();
                if (d3 <= (double)this.stopDistance) {
                    double d4 = itemEntity.getX() - this.entity.getX();
                    double d5 = itemEntity.getZ() - this.entity.getZ();
                    this.navigation.moveTo(this.entity.getX() - d4, this.entity.getY(), this.entity.getZ() - d5, (double)this.speedModifier);
                }
            }
        }
    }

    private void leapTowardTarget(@Nullable LivingEntity leapTarget) {
        if (leapTarget == null) {
            return;
        }
        double d0 = leapTarget.getX() - this.entity.getX();
        double d1 = leapTarget.getZ() - this.entity.getZ();
        float f = Mth.sqrt((float)((float)(d0 * d0 + d1 * d1)));
        Vec3 motion = this.entity.getDeltaMovement();
        if ((double)f >= 1.0E-4) {
            this.entity.setDeltaMovement(motion.add(d0 / (double)f * 0.5 * (double)0.8f + motion.x * (double)0.2f, 0.0, d1 / (double)f * 0.5 * (double)0.8f + motion.z * (double)0.2f));
        }
        this.entity.setDeltaMovement(new Vec3(motion.x, 0.25, motion.z));
    }

    @Nullable
    private ItemEntity nearbyMug() {
        List list = this.entity.level().getEntitiesOfClass(ItemEntity.class, this.entity.getBoundingBox().inflate(10.0));
        if (!list.isEmpty()) {
            for (ItemEntity item : list) {
                if (item.isInvisible() || !item.getItem().is(TropicraftItems.BAMBOO_MUG) || !item.isAlive()) continue;
                return item;
            }
        }
        return null;
    }
}

