/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.vmonkey;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.TropicraftDrinks;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;
import net.tropicraft.core.common.item.CocktailItem;

public class MonkeyPickUpPinaColadaGoal
extends Goal {
    private final VMonkeyEntity entity;
    @Nullable
    private ItemEntity drinkEntity;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;

    public MonkeyPickUpPinaColadaGoal(VMonkeyEntity monkey) {
        this.entity = monkey;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.speedModifier = 1.0;
        this.stopDistance = 1.0f;
        this.navigation = this.entity.getNavigation();
        this.drinkEntity = null;
    }

    public boolean canContinueToUse() {
        return !this.entity.isTame() && !this.entity.selfHoldingDrink(TropicraftDrinks.PINA_COLADA) && this.drinkEntity != null;
    }

    public boolean canUse() {
        if (this.entity.getRandom().nextInt(20) != 0) {
            return false;
        }
        return !this.entity.isTame() && !this.entity.selfHoldingDrink(TropicraftDrinks.PINA_COLADA) && this.hasNearbyDrink(TropicraftDrinks.PINA_COLADA) && this.drinkEntity != null;
    }

    public void stop() {
        this.navigation.stop();
        this.entity.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.getPathfindingMalus(PathType.WATER);
        this.entity.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    private boolean hasNearbyDrink(ResourceKey<Drink> drink) {
        for (ItemEntity item : this.entity.level().getEntitiesOfClass(ItemEntity.class, this.entity.getBoundingBox().inflate(10.0))) {
            if (item.isInvisible() || !item.isAlive() || !CocktailItem.hasDrink(item.getItem(), drink)) continue;
            this.drinkEntity = item;
            return true;
        }
        return false;
    }

    public void tick() {
        if (this.drinkEntity != null && !this.entity.isLeashed()) {
            this.entity.getLookControl().setLookAt((Entity)this.drinkEntity, 10.0f, (float)this.entity.getMaxHeadXRot());
            if (!this.drinkEntity.isAlive()) {
                this.drinkEntity = null;
                this.entity.setMadAboutStolenAlcohol(true);
                return;
            }
            if (this.entity.distanceToSqr((Entity)this.drinkEntity) > (double)(this.stopDistance * this.stopDistance)) {
                if (--this.timeToRecalcPath <= 0) {
                    double d2;
                    double d1;
                    this.timeToRecalcPath = 10;
                    double d0 = this.entity.getX() - this.drinkEntity.getX();
                    double d3 = d0 * d0 + (d1 = this.entity.getY() - this.drinkEntity.getY()) * d1 + (d2 = this.entity.getZ() - this.drinkEntity.getZ()) * d2;
                    if (d3 > (double)(this.stopDistance * this.stopDistance)) {
                        this.navigation.moveTo((Entity)this.drinkEntity, this.speedModifier);
                    } else {
                        this.navigation.stop();
                        if (d3 <= (double)this.stopDistance) {
                            double d4 = this.drinkEntity.getX() - this.entity.getX();
                            double d5 = this.drinkEntity.getZ() - this.entity.getZ();
                            this.navigation.moveTo(this.entity.getX() - d4, this.entity.getY(), this.entity.getZ() - d5, this.speedModifier);
                        }
                    }
                }
            } else {
                this.entity.setItemInHand(InteractionHand.MAIN_HAND, this.drinkEntity.getItem());
                this.drinkEntity.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }
}

