/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.egg;

import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class EggEntity
extends LivingEntity {
    private static final EntityDataAccessor<Integer> HATCH_DELAY = SynchedEntityData.defineId(EggEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public double rotationRand = 0.0;

    public EggEntity(EntityType<? extends EggEntity> type, Level w) {
        super(type, w);
        this.setYRot(this.random.nextInt(360));
        this.setHatchDelay(-60 + this.random.nextInt(120));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 2.0);
    }

    public void readAdditionalSaveData(ValueInput input) {
        this.tickCount = input.getIntOr("ticks", 0);
        this.setHatchDelay(input.getIntOr("hatchDelay", 0));
        super.readAdditionalSaveData(input);
    }

    public void addAdditionalSaveData(ValueOutput output) {
        output.putInt("ticks", this.tickCount);
        output.putInt("hatchDelay", this.getHatchDelay());
        super.addAdditionalSaveData(output);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HATCH_DELAY, (Object)0);
    }

    public abstract boolean shouldEggRenderFlat();

    public abstract String getEggTexture();

    @Nullable
    public abstract Entity onHatch();

    public abstract int getHatchTime();

    public abstract int getPreHatchMovement();

    public int getRandomHatchDelay() {
        return (Integer)this.getEntityData().get(HATCH_DELAY);
    }

    public boolean isHatching() {
        return this.tickCount > this.getHatchTime() + this.getRandomHatchDelay();
    }

    public boolean isNearHatching() {
        return this.tickCount > this.getHatchTime() + this.getRandomHatchDelay() - this.getPreHatchMovement();
    }

    public void aiStep() {
        super.aiStep();
        if (this.isNearHatching()) {
            this.rotationRand += (double)(0.1707f * this.level().random.nextFloat());
            if (this.tickCount >= this.getHatchTime() && !this.level().isClientSide) {
                Entity ent = this.onHatch();
                ent.snapTo(this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
                this.level().addFreshEntity(ent);
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void setHatchDelay(int i) {
        this.getEntityData().set(HATCH_DELAY, (Object)(-60 + this.random.nextInt(120)));
    }

    public int getHatchDelay() {
        return (Integer)this.getEntityData().get(HATCH_DELAY);
    }

    public boolean canUseSlot(EquipmentSlot slot) {
        return false;
    }

    public ItemStack getItemBySlot(EquipmentSlot slotIn) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.LEFT;
    }
}

