/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.egg;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.egg.EggEntity;
import net.tropicraft.core.common.entity.hostile.TropiSpiderEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class TropiSpiderEggEntity
extends EggEntity {
    @Nullable
    private EntityReference<TropiSpiderEntity> mother;

    public TropiSpiderEggEntity(EntityType<? extends EggEntity> type, Level world) {
        super(type, world);
    }

    public void setMother(TropiSpiderEntity entity) {
        this.mother = new EntityReference((UniquelyIdentifyable)entity);
    }

    @Override
    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        EntityReference.store(this.mother, (ValueOutput)output, (String)"mother");
    }

    @Override
    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.mother = EntityReference.read((ValueInput)input, (String)"mother");
    }

    @Override
    public boolean shouldEggRenderFlat() {
        return false;
    }

    @Override
    public String getEggTexture() {
        return "spideregg";
    }

    @Override
    public Entity onHatch() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            TropiSpiderEntity spider;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.mother != null && (spider = (TropiSpiderEntity)this.mother.getEntity((UUIDLookup)serverLevel, TropiSpiderEntity.class)) != null) {
                return TropiSpiderEntity.haveBaby(spider);
            }
        }
        return ((EntityType)TropicraftEntities.TROPI_SPIDER.get()).create(this.level(), EntitySpawnReason.BREEDING);
    }

    @Override
    public int getHatchTime() {
        return 2000;
    }

    @Override
    public int getPreHatchMovement() {
        return 20;
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)TropicraftItems.TROPI_SPIDER_SPAWN_EGG.get());
    }
}

