/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.hostile;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.ai.EntityAIWanderNotLazy;
import net.tropicraft.core.common.entity.egg.TropiSpiderEggEntity;

public class TropiSpiderEntity
extends Spider {
    private static final EntityDataAccessor<Byte> TYPE = SynchedEntityData.defineId(TropiSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final int SPIDER_MATURE_AGE = 12000;
    private static final int SPIDER_MAX_EGGS = 10;
    private static final long SPIDER_MIN_EGG_DELAY = 12000L;
    private static final int SPIDER_EGG_CHANCE = 1000;
    @Nullable
    private BlockPos nestSite;
    @Nullable
    private TropiSpiderEntity mother = null;
    private long ticksSinceLastEgg = 0L;
    public final byte initialType = 0;
    private boolean jumping;

    public TropiSpiderEntity(EntityType<? extends Spider> type, Level world) {
        super(type, world);
        this.tickCount = 12000;
        this.ticksSinceLastEgg = this.tickCount;
    }

    public static TropiSpiderEntity haveBaby(TropiSpiderEntity mother) {
        TropiSpiderEntity baby = new TropiSpiderEntity((EntityType<? extends Spider>)((EntityType)TropicraftEntities.TROPI_SPIDER.get()), mother.level());
        baby.setSpiderType(Type.CHILD);
        baby.tickCount = 0;
        baby.mother = mother;
        return baby;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.8, false));
        this.goalSelector.addGoal(7, (Goal)new EntityAIWanderNotLazy((PathfinderMob)this, 0.8, 40));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void actuallyHurt(ServerLevel level, DamageSource source, float amount) {
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity cause = (LivingEntity)entity;
            this.setTarget(cause);
        }
        super.actuallyHurt(level, source, amount);
    }

    public boolean onClimbable() {
        return this.isClimbing() && this.getNavigation().isDone();
    }

    public boolean isClimbing() {
        return this.horizontalCollision;
    }

    protected float getFlyingSpeed() {
        return this.jumping ? 0.3f : 0.2f;
    }

    public void tick() {
        this.fallDistance = 0.0;
        super.tick();
        LivingEntity attackTarget = this.getTarget();
        if (attackTarget != null && this.distanceToSqr((Entity)attackTarget) < 128.0) {
            Util.tryMoveToEntityLivingLongDist((Mob)this, (Entity)attackTarget, 0.8f);
        }
        if (!this.level().isClientSide && attackTarget != null && this.onGround() && this.random.nextInt(3) == 0 && attackTarget.distanceTo((Entity)this) < 5.0f) {
            this.getNavigation().stop();
            this.jumpFromGround();
            this.jumping = true;
        } else {
            this.jumping = false;
        }
        if (!this.level().isClientSide) {
            if (this.getSpiderType() == Type.CHILD) {
                if (this.tickCount >= 12000) {
                    this.setSpiderType(Type.ADULT);
                }
                if (this.mother != null) {
                    if (this.distanceToSqr((Entity)this.mother) > 16.0) {
                        Util.tryMoveToEntityLivingLongDist((Mob)this, (Entity)this.mother, 0.8f);
                    } else {
                        this.getNavigation().stop();
                    }
                    if (this.mother.getTarget() != null) {
                        this.setTarget(this.mother.getTarget());
                    }
                }
            }
            if (this.getSpiderType() == Type.ADULT) {
                if (this.mother != null) {
                    if (!this.mother.isAlive()) {
                        this.mother = null;
                        this.getNavigation().stop();
                        this.setTarget(null);
                    }
                    this.setTarget((LivingEntity)this.mother);
                }
                if (this.random.nextInt(1000) == 0 && this.ticksSinceLastEgg > 12000L && this.tickCount % 80 == 0) {
                    this.buildNest();
                }
            }
            if (this.getSpiderType() == Type.MOTHER && this.nestSite != null) {
                if (this.ticksSinceLastEgg < 2000L) {
                    if (!this.blockPosition().closerThan((Vec3i)this.nestSite, 16.0)) {
                        Util.tryMoveToXYZLongDist((Mob)this, this.nestSite, 0.9f);
                    }
                } else {
                    this.nestSite = null;
                }
            }
            ++this.ticksSinceLastEgg;
        }
    }

    protected SoundEvent getAmbientSound() {
        return this.random.nextInt(20) == 0 ? super.getAmbientSound() : null;
    }

    protected void playStepSound(BlockPos pos, BlockState blockState) {
        if (this.getSpiderType() == Type.CHILD) {
            if (this.random.nextInt(20) == 0) {
                super.playStepSound(pos, blockState);
            }
        } else {
            super.playStepSound(pos, blockState);
        }
    }

    public boolean isPushable() {
        return this.getSpiderType() != Type.MOTHER;
    }

    public void buildNest() {
        if (!this.level().isClientSide) {
            this.setSpiderType(Type.MOTHER);
            int r = this.random.nextInt(10) + 1;
            if (r < 2) {
                return;
            }
            for (int i = 0; i < r; ++i) {
                TropiSpiderEggEntity egg = (TropiSpiderEggEntity)((EntityType)TropicraftEntities.TROPI_SPIDER_EGG.get()).create(this.level(), EntitySpawnReason.BREEDING);
                egg.setMother(this);
                egg.setPos((float)this.blockPosition().getX() + this.random.nextFloat(), this.blockPosition().getY(), (float)this.blockPosition().getZ() + this.random.nextFloat());
                this.level().addFreshEntity((Entity)egg);
                this.ticksSinceLastEgg = 0L;
            }
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    if (this.random.nextInt(8) != 0) continue;
                    BlockPos pos = new BlockPos(this.blockPosition().getX() - 2 + x, this.blockPosition().getY(), this.blockPosition().getZ() - 2 + z);
                    if (!this.level().isEmptyBlock(pos) || !this.level().getBlockState(pos.below()).isSolid()) continue;
                    this.level().setBlockAndUpdate(pos, Blocks.COBWEB.defaultBlockState());
                }
            }
            this.nestSite = this.blockPosition();
        }
    }

    public void addAdditionalSaveData(ValueOutput output) {
        output.putInt("ticks", this.tickCount);
        output.putByte("spiderType", (byte)this.getSpiderType().ordinal());
        output.putLong("timeSinceLastEgg", this.ticksSinceLastEgg);
        super.addAdditionalSaveData(output);
    }

    public void readAdditionalSaveData(ValueInput input) {
        this.tickCount = input.getIntOr("ticks", 0);
        this.setSpiderType(input.getByteOr("spiderType", (byte)0));
        this.ticksSinceLastEgg = input.getLongOr("timeSinceLastEgg", 0L);
        super.readAdditionalSaveData(input);
    }

    public Type getSpiderType() {
        return Type.VALUES[(Byte)this.getEntityData().get(TYPE)];
    }

    public void setSpiderType(Type type) {
        this.getEntityData().set(TYPE, (Object)((byte)type.ordinal()));
        this.refreshDimensions();
    }

    public void setSpiderType(byte b) {
        this.getEntityData().set(TYPE, (Object)b);
        this.refreshDimensions();
    }

    public static enum Type {
        ADULT,
        MOTHER,
        CHILD;

        private static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

