/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.neutral;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.sound.Sounds;

public class IguanaEntity
extends PathfinderMob {
    private int angerLevel;
    @Nullable
    private EntityReference<Player> angerTarget;
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(Tropicraft.location("attack_speed_boost"), 0.05, AttributeModifier.Operation.ADD_VALUE);

    public IguanaEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
    }

    public void setLastHurtByMob(@Nullable LivingEntity entity) {
        super.setLastHurtByMob(entity);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.angerTarget = new EntityReference((UniquelyIdentifyable)player);
        }
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.createMobAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 5.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByAggressorGoal(this));
        this.targetSelector.addGoal(2, (Goal)new TargetAggressorGoal(this));
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putShort("Anger", (short)this.angerLevel);
        EntityReference.store(this.angerTarget, (ValueOutput)output, (String)"HurtBy");
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.angerLevel = input.getShortOr("Anger", (short)0);
        this.angerTarget = EntityReference.read((ValueInput)input, (String)"HurtBy");
        Player player = (Player)EntityReference.get(this.angerTarget, arg_0 -> ((Level)this.level()).getPlayerByUUID(arg_0), Player.class);
        this.setLastHurtByMob((LivingEntity)player);
        if (player != null) {
            this.lastHurtByPlayer = new EntityReference((UniquelyIdentifyable)player);
            this.lastHurtByPlayerMemoryTime = this.getLastHurtByMobTimestamp();
        }
    }

    protected void customServerAiStep(ServerLevel level) {
        AttributeInstance attribute = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (this.isAngry()) {
            if (!this.isBaby() && !attribute.hasModifier(ATTACK_SPEED_BOOST_MODIFIER.id())) {
                attribute.addTransientModifier(ATTACK_SPEED_BOOST_MODIFIER);
            }
            --this.angerLevel;
        } else if (attribute.hasModifier(ATTACK_SPEED_BOOST_MODIFIER.id())) {
            attribute.removeModifier(ATTACK_SPEED_BOOST_MODIFIER);
        }
        if (this.angerLevel > 0 && this.angerTarget != null && this.getLastHurtByMob() == null) {
            Player player = (Player)EntityReference.get(this.angerTarget, arg_0 -> ((Level)this.level()).getPlayerByUUID(arg_0), Player.class);
            this.setLastHurtByMob((LivingEntity)player);
            if (player != null) {
                this.setLastHurtByPlayer(player, 100);
            }
        }
        super.customServerAiStep(level);
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        Player sourcePlayer;
        if (this.isInvulnerableTo(level, source)) {
            return false;
        }
        Entity sourceEntity = source.getEntity();
        if (sourceEntity instanceof Player && !(sourcePlayer = (Player)sourceEntity).isCreative() && this.hasLineOfSight(sourceEntity)) {
            this.becomeAngryAt(sourceEntity);
        }
        return super.hurtServer(level, source, amount);
    }

    private boolean becomeAngryAt(Entity target) {
        this.angerLevel = 400 + this.random.nextInt(400);
        if (target instanceof LivingEntity) {
            this.setLastHurtByMob((LivingEntity)target);
        }
        return true;
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)Sounds.IGGY_LIVING.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)Sounds.IGGY_ATTACK.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)Sounds.IGGY_DEATH.get();
    }

    static class HurtByAggressorGoal
    extends HurtByTargetGoal {
        public HurtByAggressorGoal(IguanaEntity iguana) {
            super((PathfinderMob)iguana, new Class[0]);
            this.setAlertOthers(new Class[]{IguanaEntity.class});
        }

        protected void alertOther(Mob mob, LivingEntity target) {
            if (mob instanceof IguanaEntity && this.mob.hasLineOfSight((Entity)target) && ((IguanaEntity)mob).becomeAngryAt((Entity)target)) {
                mob.setTarget(target);
            }
        }
    }

    static class TargetAggressorGoal
    extends NearestAttackableTargetGoal<Player> {
        public TargetAggressorGoal(IguanaEntity iggy) {
            super((Mob)iggy, Player.class, true);
        }

        public boolean canUse() {
            return ((IguanaEntity)this.mob).isAngry() && super.canUse();
        }
    }
}

