/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class BirdMoveControl
extends MoveControl {
    public BirdMoveControl(Mob mob) {
        super(mob);
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            boolean movingHorizontally;
            double deltaZ;
            double deltaY;
            this.operation = MoveControl.Operation.WAIT;
            double deltaX = this.wantedX - this.mob.getX();
            if (Mth.lengthSquared((double)deltaX, (double)(deltaY = this.wantedY - this.mob.getY()), (double)(deltaZ = this.wantedZ - this.mob.getZ())) < (double)2.5E-7f) {
                this.mob.setYya(0.0f);
                this.mob.setZza(0.0f);
                return;
            }
            boolean movingVertically = Math.abs(deltaY) > (double)0.05f;
            double distanceHorizontal = Mth.length((double)deltaX, (double)deltaZ);
            boolean bl = movingHorizontally = Math.abs(distanceHorizontal) > (double)0.05f;
            if (!this.mob.onGround() || movingVertically) {
                this.mob.setNoGravity(true);
            }
            float speed = (float)(this.speedModifier * this.mob.getAttributeValue(this.mob.onGround() ? Attributes.MOVEMENT_SPEED : Attributes.FLYING_SPEED));
            if (movingHorizontally) {
                this.mob.setSpeed(speed);
                this.mob.setYRot((float)(Mth.atan2((double)deltaZ, (double)deltaX) * 57.2957763671875) - 90.0f);
            }
            if (movingVertically) {
                this.mob.setYya((float)(Math.signum(deltaY) * (double)speed * 0.5));
            }
            if (movingVertically || movingHorizontally) {
                this.mob.setXRot((float)(-(Mth.atan2((double)deltaY, (double)distanceHorizontal) * 57.2957763671875)));
            }
        } else {
            this.mob.setNoGravity(false);
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
        }
    }
}

