/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.event.EventHooks;
import net.tropicraft.core.common.TropicraftRegistries;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.TropicsFlowerBlock;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class CowktailEntity
extends Cow
implements IShearable {
    private static final EntityDataAccessor<String> COWKTAIL_TYPE = SynchedEntityData.defineId(CowktailEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public CowktailEntity(EntityType<? extends CowktailEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader worldIn) {
        return worldIn.getBlockState(pos.below()).is(Blocks.MYCELIUM) ? 10.0f : worldIn.getPathfindingCostFromLightLevels(pos);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COWKTAIL_TYPE, (Object)Type.IRIS.name);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(TropicraftItems.BAMBOO_MUG) && !this.isBaby()) {
            itemStack.consume(1, (LivingEntity)player);
            Registry drinks = this.registryAccess().lookupOrThrow(TropicraftRegistries.DRINK);
            ItemStack cocktailItem = drinks.getRandom(this.random).map(CocktailItem::makeDrink).orElse(ItemStack.EMPTY);
            if (itemStack.isEmpty()) {
                player.setItemInHand(hand, cocktailItem);
            } else if (!player.getInventory().add(cocktailItem)) {
                player.drop(cocktailItem, false);
            }
            this.playSound(SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putString("Type", this.getCowktailType().name);
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setCowktailType(input.read("Type", Type.CODEC).orElse(Type.IRIS));
    }

    private void setCowktailType(Type typeIn) {
        this.entityData.set(COWKTAIL_TYPE, (Object)typeIn.name);
    }

    public Type getCowktailType() {
        return (Type)Type.CODEC.byName((String)this.entityData.get(COWKTAIL_TYPE), (Enum)Type.IRIS);
    }

    @Nullable
    public CowktailEntity getBreedOffspring(ServerLevel level, AgeableMob partner) {
        CowktailEntity child = (CowktailEntity)((EntityType)TropicraftEntities.COWKTAIL.get()).create((Level)level, EntitySpawnReason.BREEDING);
        if (child != null) {
            child.setCowktailType(this.getOffspringType((CowktailEntity)partner));
        }
        return child;
    }

    private Type getOffspringType(CowktailEntity partner) {
        Type parnerType;
        Type type = this.getCowktailType();
        if (type == (parnerType = partner.getCowktailType()) && this.random.nextInt(1024) == 0) {
            return Type.getRandomType(this.random);
        }
        return this.random.nextBoolean() ? type : parnerType;
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return !this.isBaby();
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        this.playSound(SoundEvents.MOOSHROOM_SHEAR, 1.0f, 1.0f);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (!EventHooks.canLivingConvert((LivingEntity)this, (EntityType)EntityType.COW, timer -> {})) {
            return items;
        }
        if (!level.isClientSide()) {
            this.convertTo(EntityType.COW, ConversionParams.single((Mob)this, (boolean)false, (boolean)false), cow -> {
                EventHooks.onLivingConvert((LivingEntity)this, (LivingEntity)cow);
                level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 0.0, 0.0, 0.0);
                for (int i = 0; i < 5; ++i) {
                    items.add(new ItemStack((ItemLike)this.getCowktailType().renderState.getBlock()));
                }
            });
        }
        return items;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficultyInstance, EntitySpawnReason spawnReason, @Nullable SpawnGroupData data) {
        this.setCowktailType(Type.getRandomType(this.random));
        return super.finalizeSpawn(world, difficultyInstance, spawnReason, data);
    }

    public static enum Type implements StringRepresentable
    {
        IRIS("iris", (BlockState)((TallFlowerBlock)TropicraftBlocks.IRIS.get()).defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)),
        ANEMONE("anemone", ((TropicsFlowerBlock)((Object)TropicraftBlocks.FLOWERS.get(TropicraftFlower.ANEMONE).get())).defaultBlockState());

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private final String name;
        private final BlockState renderState;

        private Type(String nameIn, BlockState renderStateIn) {
            this.name = nameIn;
            this.renderState = renderStateIn;
        }

        public static Type getRandomType(RandomSource rand) {
            return (Type)((Object)Util.getRandom((Object[])Type.values(), (RandomSource)rand));
        }

        public String getSerializedName() {
            return this.name;
        }

        public BlockState getRenderState() {
            return this.renderState;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }
}

