/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.ai.EntityAIAvoidEntityOnLowHealth;
import net.tropicraft.core.common.entity.ai.EntityAIChillAtFire;
import net.tropicraft.core.common.entity.ai.EntityAIEatToHeal;
import net.tropicraft.core.common.entity.ai.EntityAIGoneFishin;
import net.tropicraft.core.common.entity.ai.EntityAIKoaMate;
import net.tropicraft.core.common.entity.ai.EntityAIPartyTime;
import net.tropicraft.core.common.entity.ai.EntityAIPlayKoa;
import net.tropicraft.core.common.entity.ai.EntityAITemptHelmet;
import net.tropicraft.core.common.entity.ai.EntityAIWanderNotLazy;
import net.tropicraft.core.common.entity.passive.EntityKoaHunter;
import net.tropicraft.core.common.entity.passive.FishingBobberEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class EntityKoaBase
extends Villager {
    public long lastTimeFished = 0L;
    @Nullable
    public BlockPos posLastFireplaceFound = null;
    public final List<BlockPos> listPosDrums = new ArrayList<BlockPos>();
    public static final int MAX_DRUMS = 12;
    public final SimpleContainer inventory = new SimpleContainer(9);
    private static final EntityDataAccessor<Integer> ROLE = SynchedEntityData.defineId(EntityKoaBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.defineId(EntityKoaBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityKoaBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.defineId(EntityKoaBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> LURE_ID = SynchedEntityData.defineId(EntityKoaBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final MapCodec<BlockPos> FIREPLACE_POS_CODEC = EntityKoaBase.legacyBlockPosCodec("fireplace");
    private static final List<MapCodec<BlockPos>> DRUM_CODECS = IntStream.range(0, 12).mapToObj(i -> EntityKoaBase.legacyBlockPosCodec("drum_" + i)).toList();
    private float clientHealthLastTracked = 0.0f;
    public static final int MAX_HOME_DISTANCE = 128;
    private int villageID = -1;
    @Nullable
    private ResourceKey<Level> villageDimension;
    @Nullable
    private FishingBobberEntity lure;
    private boolean wasInWater = false;
    private boolean wasNightLastTick = false;
    private boolean wantsToParty = false;
    public boolean jumpingOutOfWater = false;
    public int hitIndex = 0;
    public int hitIndex2 = 0;
    public int hitIndex3 = 0;
    public int hitDelay = 0;
    private long lastTradeTime = 0L;
    private static final int TRADE_COOLDOWN = 72000;
    private static final int DIVE_TIME_NEEDED = 3600;
    public final boolean debug = false;
    public int druggedTime = 0;
    private static final Set<ItemEntry<? extends Item>> TEMPTATION_ITEMS = Set.of(TropicraftItems.NIGEL_STACHE);
    private boolean isMating;
    private boolean isPlaying;
    private boolean finalizedSpawn;
    private int updateMerchantTimer;
    private boolean increaseProfessionLevelOnUpdate;
    public static final TargetingConditions.Selector ENEMY_PREDICATE = (input, level) -> input instanceof Monster;

    private static MapCodec<BlockPos> legacyBlockPosCodec(String name) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.INT.fieldOf(name + "_X").forGetter(Vec3i::getX), (App)Codec.INT.fieldOf(name + "_Y").forGetter(Vec3i::getY), (App)Codec.INT.fieldOf(name + "_Z").forGetter(Vec3i::getZ)).apply((Applicative)i, BlockPos::new));
    }

    public EntityKoaBase(EntityType<? extends EntityKoaBase> type, Level level) {
        super(type, level);
    }

    public boolean fireImmune() {
        return true;
    }

    public long getLastTradeTime() {
        return this.lastTradeTime;
    }

    public void setLastTradeTime(long lastTradeTime) {
        this.lastTradeTime = lastTradeTime;
    }

    public Genders getGender() {
        return Genders.get((Integer)this.getEntityData().get(GENDER));
    }

    public void setGender(Genders gender) {
        this.getEntityData().set(GENDER, (Object)gender.ordinal());
    }

    public Roles getRole() {
        return Roles.get((Integer)this.getEntityData().get(ROLE));
    }

    public boolean isSitting() {
        return (Boolean)this.getEntityData().get(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.getEntityData().set(SITTING, (Object)sitting);
    }

    public boolean isDancing() {
        return (Boolean)this.getEntityData().get(DANCING);
    }

    public void setDancing(boolean val) {
        this.getEntityData().set(DANCING, (Object)val);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ROLE, (Object)0);
        builder.define(GENDER, (Object)0);
        builder.define(SITTING, (Object)false);
        builder.define(DANCING, (Object)false);
        builder.define(LURE_ID, (Object)-1);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        int id;
        super.onSyncedDataUpdated(key);
        if (!this.level().isClientSide) {
            return;
        }
        if (key == LURE_ID && (id = ((Integer)this.getEntityData().get(LURE_ID)).intValue()) == -1) {
            this.setLure(null);
        }
    }

    protected void registerGoals() {
    }

    private Int2ObjectMap<VillagerTrades.ItemListing[]> getTradesByLevel() {
        return switch (this.getRole().ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> EntityKoaBase.getFishermanTrades();
            case 0 -> EntityKoaBase.getHunterTrades();
        };
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> getFishermanTrades() {
        Int2ObjectOpenHashMap tradesByLevel = new Int2ObjectOpenHashMap();
        tradesByLevel.put(1, (Object)new VillagerTrades.ItemListing[]{new ItemToPearlTrade((ItemLike)Items.TROPICAL_FISH, 20, 8, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.FISHING_NET.get(), 1, 8, 2), new ItemToPearlTrade((ItemLike)Items.FISHING_ROD, 1, 8, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.FRESH_MARLIN.get(), 3, 8, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.SARDINE_BUCKET.get(), 1, 4, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.PIRANHA_BUCKET.get(), 1, 3, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.TROPICAL_FERTILIZER.get(), 5, 8, 2)});
        tradesByLevel.put(2, (Object)new VillagerTrades.ItemListing[]{new PearlToItemTrade((ItemLike)TropicraftItems.COOKED_FISH.get(), 8, 1, 8, 10), new PearlToItemTrade((ItemLike)TropicraftItems.COOKED_RAY.get(), 6, 1, 8, 10)});
        tradesByLevel.put(3, (Object)new VillagerTrades.ItemListing[]{new ItemToPearlTrade((ItemLike)TropicraftItems.GRAPEFRUIT.get(), 12, 12, 15), new ItemToPearlTrade((ItemLike)TropicraftItems.LEMON.get(), 12, 12, 15), new ItemToPearlTrade((ItemLike)TropicraftItems.LIME.get(), 12, 12, 15)});
        return tradesByLevel;
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> getHunterTrades() {
        Int2ObjectOpenHashMap tradesByLevel = new Int2ObjectOpenHashMap();
        tradesByLevel.put(1, (Object)new VillagerTrades.ItemListing[]{new ItemToPearlTrade((ItemLike)TropicraftItems.FROG_LEG.get(), 5, 8, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.IGUANA_LEATHER.get(), 2, 8, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.SCALE.get(), 5, 8, 2)});
        tradesByLevel.put(2, (Object)new VillagerTrades.ItemListing[]{new PearlToEnchantItemTrade((ItemLike)TropicraftItems.BAMBOO_SPEAR.get(), 1, 8, 10), new ItemToPearlTrade((ItemLike)TropicraftItems.BAMBOO_STICK.get(), 32, 12, 8)});
        tradesByLevel.put(3, (Object)new VillagerTrades.ItemListing[]{new PearlToEnchantItemTrade((ItemLike)TropicraftItems.SCALE_HELMET.get(), 4, 4, 15), new PearlToEnchantItemTrade((ItemLike)TropicraftItems.SCALE_CHESTPLATE.get(), 6, 4, 15)});
        tradesByLevel.put(4, (Object)new VillagerTrades.ItemListing[]{new PearlToEnchantItemTrade((ItemLike)TropicraftItems.SCALE_LEGGINGS.get(), 5, 4, 20), new PearlToEnchantItemTrade((ItemLike)TropicraftItems.SCALE_BOOTS.get(), 4, 4, 20)});
        return tradesByLevel;
    }

    protected void updateTrades() {
        VillagerData data = this.getVillagerData();
        VillagerTrades.ItemListing[] possibleTrades = (VillagerTrades.ItemListing[])this.getTradesByLevel().get(data.level());
        if (possibleTrades != null) {
            this.addOffersFromItemListings(this.getOffers(), possibleTrades, 2);
        }
    }

    public void updateUniqueEntityAI() {
        this.goalSelector.getAvailableGoals().forEach(WrappedGoal::stop);
        this.targetSelector.getAvailableGoals().forEach(WrappedGoal::stop);
        int curPri = 0;
        this.goalSelector.addGoal(curPri++, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(curPri++, new EntityAIAvoidEntityOnLowHealth<LivingEntity>((PathfinderMob)this, LivingEntity.class, entity -> ENEMY_PREDICATE.test((LivingEntity)entity, (ServerLevel)entity.level()), 12.0f, 1.4, 1.4, 15.0f));
        this.goalSelector.addGoal(curPri++, (Goal)new EntityAIEatToHeal(this));
        this.goalSelector.addGoal(curPri++, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(curPri++, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.0, true){

            public void start() {
                super.start();
                if (this.mob instanceof EntityKoaBase) {
                    ((EntityKoaBase)this.mob).setFightingItem();
                }
            }
        });
        this.goalSelector.addGoal(curPri++, (Goal)new EntityAITemptHelmet((PathfinderMob)this, 1.0, false, TEMPTATION_ITEMS));
        this.goalSelector.addGoal(curPri++, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(curPri++, (Goal)new EntityAIKoaMate(this));
        this.goalSelector.addGoal(curPri++, (Goal)new EntityAIChillAtFire(this));
        this.goalSelector.addGoal(curPri++, (Goal)new EntityAIPartyTime(this));
        if (this.canFish()) {
            this.goalSelector.addGoal(curPri++, (Goal)new EntityAIGoneFishin(this));
        }
        if (this.isBaby()) {
            this.goalSelector.addGoal(curPri++, (Goal)new EntityAIPlayKoa(this, 1.2));
        }
        this.goalSelector.addGoal(curPri, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(curPri++, (Goal)new EntityAIWanderNotLazy((PathfinderMob)this, 1.0, 40));
        this.goalSelector.addGoal(curPri++, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        if (this.canHunt()) {
            this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, ENEMY_PREDICATE));
        }
    }

    public Villager getBreedOffspring(ServerLevel world, AgeableMob ageable) {
        EntityKoaHunter child = new EntityKoaHunter((EntityType<? extends EntityKoaHunter>)((EntityType)TropicraftEntities.KOA.get()), this.level());
        child.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(child.blockPosition()), EntitySpawnReason.BREEDING, null);
        return child;
    }

    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        this.updateUniqueEntityAI();
    }

    public boolean canFish() {
        return ((Integer)this.getEntityData().get(ROLE)).intValue() == Roles.FISHERMAN.ordinal();
    }

    public boolean canHunt() {
        return ((Integer)this.getEntityData().get(ROLE)).intValue() == Roles.HUNTER.ordinal() && !this.isBaby();
    }

    public void setHunter() {
        this.getEntityData().set(ROLE, (Object)Roles.HUNTER.ordinal());
        this.setFightingItem();
    }

    public void setFisher() {
        this.getEntityData().set(ROLE, (Object)Roles.FISHERMAN.ordinal());
        this.setFishingItem();
    }

    protected void customServerAiStep(ServerLevel level) {
        if (!this.isTrading() && this.updateMerchantTimer > 0 && --this.updateMerchantTimer <= 0) {
            if (this.increaseProfessionLevelOnUpdate) {
                this.increaseMerchantCareer();
                this.increaseProfessionLevelOnUpdate = false;
            }
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 0));
        }
        this.monitorHomeVillage();
        this.findAndSetHomeToCloseChest(false);
        this.findAndSetFireSource(false);
        this.findAndSetDrums(false);
        this.findAndSetTownID(false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Villager.createAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ARMOR, 2.0);
    }

    public void setTarget(@Nullable LivingEntity entitylivingbaseIn) {
        super.setTarget(entitylivingbaseIn);
    }

    public boolean doHurtTarget(ServerLevel level, Entity entity) {
        float damage = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        DamageSource source = this.damageSources().mobAttack((LivingEntity)this);
        boolean didHurt = entity.hurtServer(level, source, damage = EnchantmentHelper.modifyDamage((ServerLevel)level, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)source, (float)damage));
        if (didHurt) {
            float knockback = this.getKnockback(entity, source);
            if (knockback > 0.0f && entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                livingentity.knockback((double)(knockback * 0.5f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
            }
            EnchantmentHelper.doPostAttackEffects((ServerLevel)level, (Entity)entity, (DamageSource)source);
            this.setLastHurtMob(entity);
            this.playAttackSound();
        }
        return didHurt;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        InteractionResult.Pass ret = InteractionResult.PASS;
        boolean doTrade = true;
        if (!this.level().isClientSide) {
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (!stack.isEmpty() && stack.is(TropicraftItems.POISON_FROG_SKIN)) {
                doTrade = false;
                this.dbg("koa drugged, zapping memory");
                stack.consume(1, (LivingEntity)player);
                this.zapMemory();
                this.druggedTime += 2400;
                this.addEffect(new MobEffectInstance(MobEffects.NAUSEA, this.druggedTime));
                this.findAndSetDrums(true);
            }
            if (doTrade) {
                ret = super.mobInteract(player, hand);
            }
        }
        return ret;
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getDeathSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return null;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData spawnData) {
        this.setHomeTo(this.blockPosition(), 128);
        RandomSource random = level.getRandom();
        this.rollDiceChild(random);
        this.rollDiceRole(random);
        this.rollDiceGender(random);
        this.updateUniqueEntityAI();
        this.finalizedSpawn = true;
        return super.finalizeSpawn(level, difficulty, reason, spawnData);
    }

    public void rollDiceChild(RandomSource random) {
        int childChance = 20;
        if (childChance >= random.nextInt(100)) {
            this.setAge(-24000);
        }
    }

    public void rollDiceRole(RandomSource random) {
        int randValRole = random.nextInt(Roles.values().length);
        if (randValRole == Roles.FISHERMAN.ordinal()) {
            this.setFisher();
        } else if (randValRole == Roles.HUNTER.ordinal()) {
            this.setHunter();
        }
    }

    public void rollDiceGender(RandomSource random) {
        this.getEntityData().set(GENDER, (Object)random.nextInt(Genders.values().length));
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        if (this.posLastFireplaceFound != null) {
            output.store(FIREPLACE_POS_CODEC, (Object)this.posLastFireplaceFound);
        }
        output.putLong("lastTimeFished", this.lastTimeFished);
        ValueOutput.TypedOutputList inventoryOutput = output.list("koa_inventory", ItemStackWithSlot.CODEC);
        for (int slot = 0; slot < this.inventory.getContainerSize(); ++slot) {
            ItemStack stack = this.inventory.getItem(slot);
            if (stack.isEmpty()) continue;
            inventoryOutput.add((Object)new ItemStackWithSlot(slot, stack));
        }
        output.putInt("role_id", ((Integer)this.getEntityData().get(ROLE)).intValue());
        output.putInt("gender_id", ((Integer)this.getEntityData().get(GENDER)).intValue());
        output.putInt("village_id", this.villageID);
        if (this.villageDimension != null) {
            output.putString("village_dimension", this.villageDimension.location().toString());
        }
        output.putLong("lastTradeTime", this.lastTradeTime);
        for (int i = 0; i < this.listPosDrums.size(); ++i) {
            output.store(DRUM_CODECS.get(i), (Object)this.listPosDrums.get(i));
        }
        output.putInt("druggedTime", this.druggedTime);
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        if (input.child("fireplace_X").isPresent()) {
            this.setFirelacePos(input.read(FIREPLACE_POS_CODEC).orElse(null));
        }
        this.lastTimeFished = input.getLongOr("lastTimeFished", 0L);
        for (ItemStackWithSlot slot : input.listOrEmpty("koa_inventory", ItemStackWithSlot.CODEC)) {
            if (!slot.isValidInContainer(this.inventory.getContainerSize())) continue;
            this.inventory.setItem(slot.slot(), slot.stack());
        }
        this.villageID = input.getIntOr("village_id", -1);
        this.villageDimension = input.read("village_dimension", ResourceKey.codec((ResourceKey)Registries.DIMENSION)).orElse(this.level().dimension());
        input.getInt("role_id").ifPresentOrElse(roleId -> this.getEntityData().set(ROLE, roleId), () -> this.rollDiceRole(this.random));
        input.getInt("gender_id").ifPresentOrElse(genderId -> this.getEntityData().set(GENDER, genderId), () -> this.rollDiceGender(this.random));
        this.lastTradeTime = input.getLongOr("lastTradeTime", 0L);
        this.listPosDrums.clear();
        for (int i = 0; i < 12; ++i) {
            if (!input.child("drum_" + i + "_X").isPresent()) continue;
            input.read(DRUM_CODECS.get(i)).ifPresent(this.listPosDrums::add);
        }
        this.druggedTime = input.getIntOr("druggedTime", 0);
        this.updateUniqueEntityAI();
    }

    public void setFishingItem() {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.FISHING_ROD));
    }

    public void setFightingItem() {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TropicraftItems.DAGGER.get()));
    }

    public void monitorHomeVillage() {
        if (this.villageDimension != null && this.level().dimension() != this.villageDimension) {
            this.dbg("koa detected different dimension, zapping memory");
            this.zapMemory();
            this.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 5));
        }
    }

    public void findAndSetHomeToCloseChest(boolean force) {
        if (!force && (this.level().getGameTime() + (long)this.getId()) % 600L != 0L) {
            return;
        }
        boolean tryFind = false;
        if (!this.hasHome()) {
            tryFind = true;
        } else {
            BlockEntity tile = this.level().getBlockEntity(this.getHomePosition());
            if (!(tile instanceof ChestBlockEntity)) {
                tryFind = true;
            }
        }
        if (tryFind) {
            int range = 20;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range / 2; y <= range / 2; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos pos = this.blockPosition().offset(x, y, z);
                        BlockEntity tile = this.level().getBlockEntity(pos);
                        if (!(tile instanceof ChestBlockEntity)) continue;
                        this.dbg("found chest, updating home position to " + String.valueOf(pos));
                        this.setHomeTo(pos, 128);
                        return;
                    }
                }
            }
        }
    }

    public boolean findAndSetTownID(boolean force) {
        if (!force && (this.level().getGameTime() + (long)this.getId()) % 600L != 0L) {
            return false;
        }
        boolean tryFind = false;
        if (this.villageID == -1 || this.villageDimension == null) {
            tryFind = true;
            this.villageID = -1;
        }
        if (tryFind) {
            List listEnts = this.level().getEntitiesOfClass(EntityKoaBase.class, new AABB(this.blockPosition()).inflate(20.0, 20.0, 20.0));
            Collections.shuffle(listEnts);
            for (EntityKoaBase ent : listEnts) {
                if (ent.villageID == -1 || ent.villageDimension == null) continue;
                this.setVillageAndDimID(ent.villageID, ent.villageDimension);
                break;
            }
        }
        return this.villageID != -1;
    }

    public void findAndSetFireSource(boolean force) {
        if (!force && (this.level().getGameTime() + (long)this.getId()) % 600L != 0L) {
            return;
        }
        boolean tryFind = false;
        if (this.posLastFireplaceFound == null) {
            tryFind = true;
        } else {
            BlockState state = this.level().getBlockState(this.posLastFireplaceFound);
            if (state.getBlock() != Blocks.CAMPFIRE) {
                this.posLastFireplaceFound = null;
                tryFind = true;
            }
        }
        if (tryFind) {
            int range = 20;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range / 2; y <= range / 2; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos pos = this.blockPosition().offset(x, y, z);
                        BlockState state = this.level().getBlockState(pos);
                        if (!state.is(Blocks.CAMPFIRE)) continue;
                        this.dbg("found fire place spot to chill");
                        this.setFirelacePos(pos);
                        return;
                    }
                }
            }
            List listEnts = this.level().getEntitiesOfClass(EntityKoaBase.class, new AABB(this.blockPosition()).inflate(20.0, 20.0, 20.0));
            Collections.shuffle(listEnts);
            for (EntityKoaBase ent : listEnts) {
                BlockState state;
                if (ent.posLastFireplaceFound == null || !(state = this.level().getBlockState(ent.posLastFireplaceFound)).is(Blocks.CAMPFIRE)) continue;
                this.posLastFireplaceFound = new BlockPos((Vec3i)ent.posLastFireplaceFound);
                this.dbg("found fire place spot to chill from entity");
                return;
            }
        }
    }

    public void syncBPM() {
        if ((this.level().getGameTime() + (long)this.getId()) % 20L != 0L) {
            return;
        }
        List listEnts = this.level().getEntitiesOfClass(EntityKoaBase.class, new AABB(this.blockPosition()).inflate(10.0, 5.0, 10.0));
        for (EntityKoaBase ent : listEnts) {
            if (this.hitDelay == ent.hitDelay) continue;
            this.hitDelay = ent.hitDelay;
            this.hitIndex = ent.hitIndex;
            this.hitIndex2 = ent.hitIndex2;
            this.hitIndex3 = ent.hitIndex3;
            return;
        }
    }

    public boolean isInstrument(BlockPos pos) {
        BlockState state = this.level().getBlockState(pos);
        return state.is(TropicraftTags.Blocks.BONGOS) || state.is(Blocks.NOTE_BLOCK);
    }

    public void findAndSetDrums(boolean force) {
        if (!force && (this.level().getGameTime() + (long)this.getId()) % 600L != 0L) {
            return;
        }
        this.listPosDrums.removeIf(pos -> !this.isInstrument((BlockPos)pos));
        if (this.listPosDrums.size() >= 12) {
            return;
        }
        List listEnts = this.level().getEntitiesOfClass(EntityKoaBase.class, new AABB(this.blockPosition()).inflate(20.0, 20.0, 20.0));
        Collections.shuffle(listEnts);
        for (EntityKoaBase ent : listEnts) {
            if (this.listPosDrums.size() >= 12) {
                return;
            }
            for (BlockPos pos2 : ent.listPosDrums) {
                boolean match = false;
                for (BlockPos pos22 : this.listPosDrums) {
                    if (!pos2.equals((Object)pos22)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    this.listPosDrums.add(pos2);
                }
                if (this.listPosDrums.size() < 12) continue;
                return;
            }
        }
        int range = 20;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range / 2; y <= range / 2; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos pos3 = this.blockPosition().offset(x, y, z);
                    if (!this.isInstrument(pos3)) continue;
                    boolean match = false;
                    for (BlockPos pos2 : this.listPosDrums) {
                        if (!pos3.equals((Object)pos2)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        this.listPosDrums.add(pos3);
                    }
                    if (this.listPosDrums.size() < 12) continue;
                    return;
                }
            }
        }
    }

    public boolean tryDumpInventoryIntoHomeChest() {
        BlockEntity tile = this.level().getBlockEntity(this.getHomePosition());
        if (tile instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)tile;
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.inventory.getItem(i);
                if (itemstack.isEmpty()) continue;
                this.inventory.setItem(i, this.addItem(chest, itemstack));
            }
        }
        return true;
    }

    @Nullable
    public ItemStack addItem(ChestBlockEntity chest, ItemStack stack) {
        ItemStack itemstack = stack.copy();
        for (int i = 0; i < chest.getContainerSize(); ++i) {
            ItemStack itemstack1 = chest.getItem(i);
            if (itemstack1.isEmpty()) {
                chest.setItem(i, itemstack);
                chest.setChanged();
                return ItemStack.EMPTY;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            int j = Math.min(chest.getMaxStackSize(), itemstack1.getMaxStackSize());
            int k = Math.min(itemstack.getCount(), j - itemstack1.getCount());
            if (k <= 0) continue;
            itemstack1.grow(k);
            itemstack.shrink(k);
            if (itemstack.getCount() > 0) continue;
            chest.setChanged();
            return ItemStack.EMPTY;
        }
        if (itemstack.getCount() != stack.getCount()) {
            chest.setChanged();
        }
        return itemstack;
    }

    public void setFirelacePos(@Nullable BlockPos pos) {
        this.posLastFireplaceFound = pos;
    }

    protected void rewardTradeXp(MerchantOffer offer) {
        super.rewardTradeXp(offer);
        if (this.shouldIncreaseLevel()) {
            this.updateMerchantTimer = 40;
            this.increaseProfessionLevelOnUpdate = true;
        }
        if (this.random.nextInt(3) == 0) {
            this.restock();
        }
    }

    private boolean shouldIncreaseLevel() {
        int level = this.getVillagerData().level();
        return VillagerData.canLevelUp((int)level) && this.getVillagerXp() >= VillagerData.getMaxXpPerLevel((int)level);
    }

    private void increaseMerchantCareer() {
        this.setVillagerData(this.getVillagerData().withLevel(this.getVillagerData().level() + 1));
        this.updateTrades();
    }

    public void restock() {
        for (MerchantOffer offer : this.getOffers()) {
            offer.resetUses();
        }
    }

    public void aiStep() {
        if (this.finalizedSpawn) {
            this.finalizedSpawn = false;
            this.findAndSetHomeToCloseChest(true);
            this.findAndSetFireSource(true);
            this.findAndSetDrums(true);
        }
        this.updateSwingTime();
        super.aiStep();
        if (this.wasInWater && !this.isInWater() && this.horizontalCollision) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)0.4f, 0.0));
            this.jumpingOutOfWater = true;
        }
        if (this.jumpingOutOfWater && this.onGround()) {
            this.jumpingOutOfWater = false;
            this.getNavigation().stop();
        }
        if (this.isInWater()) {
            if (this.isBaby()) {
                if (this.getDeltaMovement().y < (double)-0.1f) {
                    this.getDeltaMovement().add(0.0, 0.25, 0.0);
                }
            } else if (this.getDeltaMovement().y < (double)-0.2f) {
                this.getDeltaMovement().add(0.0, (double)0.15f, 0.0);
            }
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.6);
            this.setPathfindingMalus(PathType.WATER, 8.0f);
        } else {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.28);
            this.setPathfindingMalus(PathType.WATER, -1.0f);
        }
        this.wasInWater = this.isInWater();
        if (!this.wasNightLastTick && !this.level().isBrightOutside()) {
            this.rollDiceParty();
        }
        boolean bl = this.wasNightLastTick = !this.level().isBrightOutside();
        if (!this.level().isClientSide && this.druggedTime > 0) {
            --this.druggedTime;
        }
        if (this.level().isClientSide && this.clientHealthLastTracked != this.getHealth()) {
            if (this.getHealth() > this.clientHealthLastTracked) {
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, false, false, this.getX(), this.getY() + 2.2, this.getZ(), 0.0, 0.0, 0.0);
            }
            this.clientHealthLastTracked = this.getHealth();
        }
    }

    public void heal(float healAmount) {
        super.heal(healAmount);
    }

    public void setMating(boolean mating) {
        this.isMating = mating;
    }

    public boolean isMating() {
        return this.isMating;
    }

    public boolean getIsWillingToMate(boolean updateFirst) {
        this.setIsWillingToMate(true);
        return true;
    }

    public void setIsWillingToMate(boolean b) {
    }

    public int getVillageID() {
        return this.villageID;
    }

    public void setVillageAndDimID(int villageID, ResourceKey<Level> villageDimID) {
        this.villageID = villageID;
        this.villageDimension = villageDimID;
    }

    @Nullable
    public ResourceKey<Level> getVillageDimension() {
        return this.villageDimension;
    }

    public void remove(Entity.RemovalReason pReason) {
        super.remove(pReason);
        if (!this.level().isClientSide) {
            // empty if block
        }
    }

    public void hookUnloaded() {
        if (!this.level().isClientSide) {
            // empty if block
        }
    }

    @Nullable
    public FishingBobberEntity getLure() {
        return this.lure;
    }

    public void setLure(@Nullable FishingBobberEntity lure) {
        this.lure = lure;
        if (!this.level().isClientSide) {
            if (lure != null) {
                this.getEntityData().set(LURE_ID, (Object)lure.getId());
            } else {
                this.getEntityData().set(LURE_ID, (Object)-1);
            }
        }
    }

    public boolean isPartyNight() {
        long time = this.level().getDayTime();
        long day = time / 24000L;
        return day % 3L == 0L;
    }

    public void rollDiceParty() {
        int chance;
        if (this.isPartyNight() && (chance = 90) >= this.random.nextInt(100)) {
            this.wantsToParty = true;
            return;
        }
        this.wantsToParty = false;
    }

    public boolean getWantsToParty() {
        return this.wantsToParty;
    }

    public Component getTypeName() {
        return Component.translatable((String)("entity.tropicraft.koa." + this.getGender().toString().toLowerCase(Locale.ROOT) + "." + this.getRole().toString().toLowerCase(Locale.ROOT) + ".name"));
    }

    public void thunderHit(ServerLevel world, LightningBolt lightning) {
    }

    public void zapMemory() {
        this.listPosDrums.clear();
        this.clearHome();
        this.setFirelacePos(null);
        this.villageDimension = null;
        this.villageID = -1;
    }

    public void dbg(String msg) {
    }

    public void playSound(SoundEvent soundIn, float volume, float pitch) {
        if (soundIn == SoundEvents.VILLAGER_YES || soundIn == SoundEvents.VILLAGER_NO) {
            return;
        }
        super.playSound(soundIn, volume, pitch);
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public static enum Genders {
        MALE,
        FEMALE;

        private static final Map<Integer, Genders> lookup;

        public static Genders get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, Genders>();
            for (Genders e : EnumSet.allOf(Genders.class)) {
                lookup.put(e.ordinal(), e);
            }
        }
    }

    public static enum Roles {
        HUNTER,
        FISHERMAN;

        private static final Map<Integer, Roles> lookup;

        public static Roles get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, Roles>();
            for (Roles e : EnumSet.allOf(Roles.class)) {
                lookup.put(e.ordinal(), e);
            }
        }
    }

    static class ItemToPearlTrade
    implements VillagerTrades.ItemListing {
        private final Item item;
        private final int count;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;

        public ItemToPearlTrade(ItemLike item, int count, int maxUses, int givenXP) {
            this.item = item.asItem();
            this.count = count;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer getOffer(Entity entity, RandomSource random) {
            ItemCost cost = new ItemCost((ItemLike)this.item, this.count);
            return new MerchantOffer(cost, new ItemStack((ItemLike)TropicraftItems.WHITE_PEARL.get()), this.maxUses, this.givenXP, this.priceMultiplier);
        }
    }

    static class PearlToItemTrade
    implements VillagerTrades.ItemListing {
        private final Item item;
        private final int count;
        private final int sellCount;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;

        public PearlToItemTrade(ItemLike item, int count, int sellCount, int maxUses, int givenXP) {
            this.item = item.asItem();
            this.count = count;
            this.sellCount = sellCount;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer getOffer(Entity entity, RandomSource random) {
            ItemStack stack = new ItemStack((ItemLike)this.item, this.count);
            return new MerchantOffer(new ItemCost((ItemLike)TropicraftItems.WHITE_PEARL.get(), this.sellCount), stack, this.maxUses, this.givenXP, this.priceMultiplier);
        }
    }

    static class PearlToEnchantItemTrade
    implements VillagerTrades.ItemListing {
        private final Item item;
        private final int sellCount;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;

        public PearlToEnchantItemTrade(ItemLike item, int sellCount, int maxUses, int givenXP) {
            this.item = item.asItem();
            this.sellCount = sellCount;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer getOffer(Entity entity, RandomSource random) {
            int enchantLevel = random.nextInt(10) + 5;
            int cost = Mth.floor((float)((float)enchantLevel / 1.5f));
            RegistryAccess registries = entity.registryAccess();
            ItemStack stack = new ItemStack((ItemLike)this.item, 1);
            stack = EnchantmentHelper.enchantItem((RandomSource)random, (ItemStack)stack, (int)enchantLevel, (RegistryAccess)registries, (Optional)registries.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.ON_TRADED_EQUIPMENT));
            return new MerchantOffer(new ItemCost((ItemLike)TropicraftItems.WHITE_PEARL.get(), this.sellCount + cost), stack, this.maxUses, this.givenXP, this.priceMultiplier);
        }
    }
}

