/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.TropicraftEntities;

public class FailgullEntity
extends Animal
implements FlyingAnimal {
    private boolean isFlockLeader;
    @Nullable
    private EntityReference<FailgullEntity> flockLeader;

    public FailgullEntity(EntityType<? extends FailgullEntity> type, Level world) {
        super(type, world);
        this.xpReward = 1;
        this.moveControl = new FlyingMoveControl((Mob)this, 5, true);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 3.0).add(Attributes.MOVEMENT_SPEED, 0.6).add(Attributes.FLYING_SPEED, 0.9).add(Attributes.FOLLOW_RANGE, 12.0);
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.isFlockLeader = input.getBooleanOr("IsFlockLeader", false);
        this.flockLeader = EntityReference.read((ValueInput)input, (String)"FlockLeader");
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putBoolean("IsFlockLeader", this.isFlockLeader);
        EntityReference.store(this.flockLeader, (ValueOutput)output, (String)"FlockLeader");
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader worldIn) {
        return worldIn.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    public void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new ValidateFlockLeader(this));
        this.goalSelector.addGoal(1, (Goal)new SelectFlockLeader(this));
        this.goalSelector.addGoal(2, (Goal)new SetTravelDestination());
        this.goalSelector.addGoal(2, (Goal)new FollowLeaderGoal());
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected PathNavigation createNavigation(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation(this, (Mob)this, worldIn){

            public boolean isStableDestination(BlockPos pos) {
                return !this.level.isEmptyBlock(pos.below());
            }
        };
        flyingpathnavigator.setCanOpenDoors(false);
        flyingpathnavigator.setCanFloat(false);
        return flyingpathnavigator;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return null;
    }

    protected SoundEvent getDeathSound() {
        return null;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob partner) {
        return null;
    }

    private void setIsFlockLeader(boolean isFlockLeader) {
        this.isFlockLeader = isFlockLeader;
    }

    private boolean getIsFlockLeader() {
        return this.isFlockLeader;
    }

    private boolean hasFlockLeader() {
        return this.flockLeader != null;
    }

    @Nullable
    private Entity getFlockLeader() {
        return (Entity)EntityReference.get(this.flockLeader, (UUIDLookup)this.level(), FailgullEntity.class);
    }

    @Nullable
    private BlockPos getRandomLocation() {
        RandomSource random = this.getRandom();
        for (int i = 0; i < 20; ++i) {
            BlockPos pos = BlockPos.containing((double)(this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 48.0f)), (double)(this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 3.0f)), (double)(this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 48.0f)));
            if (!this.level().isEmptyBlock(pos)) continue;
            return pos;
        }
        Vec3 direction = this.getViewVector(0.0f);
        float maxAngle = 1.5707964f;
        Vec3 target = HoverRandomPos.getPos((PathfinderMob)this, (int)40, (int)3, (double)direction.x, (double)direction.z, (float)1.5707964f, (int)2, (int)1);
        Vec3 groundPos = AirAndWaterRandomPos.getPos((PathfinderMob)this, (int)40, (int)4, (int)-2, (double)direction.x, (double)direction.z, (double)1.5707963705062866);
        return target != null ? BlockPos.containing((Position)target) : (groundPos != null ? BlockPos.containing((Position)groundPos) : null);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    private static class ValidateFlockLeader
    extends Goal {
        final FailgullEntity mob;

        public ValidateFlockLeader(FailgullEntity failgullEntity) {
            this.mob = failgullEntity;
        }

        public boolean canUse() {
            if (this.mob.getIsFlockLeader()) {
                return false;
            }
            Entity flockLeader = this.mob.getFlockLeader();
            return flockLeader == null || !flockLeader.isAlive();
        }

        public void start() {
            this.mob.flockLeader = null;
        }
    }

    private static class SelectFlockLeader
    extends Goal {
        final FailgullEntity mob;

        public SelectFlockLeader(FailgullEntity failgullEntity) {
            this.mob = failgullEntity;
        }

        public boolean canUse() {
            return !this.mob.hasFlockLeader();
        }

        public void start() {
            List list = this.mob.level().getEntitiesOfClass(FailgullEntity.class, this.mob.getBoundingBox().inflate(10.0, 10.0, 10.0));
            list.remove((Object)this.mob);
            Optional<FailgullEntity> oldest = list.stream().min(Comparator.comparingInt(Entity::getId));
            if (oldest.isPresent() && !oldest.get().uuid.equals(this.mob.getUUID())) {
                FailgullEntity oldestFailgull = oldest.get();
                oldestFailgull.setIsFlockLeader(true);
                oldestFailgull.flockLeader = null;
                this.mob.setIsFlockLeader(false);
                this.mob.flockLeader = new EntityReference((UniquelyIdentifyable)oldestFailgull);
            }
        }
    }

    class SetTravelDestination
    extends Goal {
        SetTravelDestination() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private boolean shouldLead() {
            return FailgullEntity.this.getIsFlockLeader() || !FailgullEntity.this.hasFlockLeader();
        }

        public boolean canUse() {
            return this.shouldLead() && FailgullEntity.this.getNavigation().isDone() && FailgullEntity.this.getRandom().nextInt(10) == 0;
        }

        public boolean canContinueToUse() {
            return this.shouldLead() && FailgullEntity.this.getNavigation().isInProgress();
        }

        public void start() {
            BlockPos Vector3d = FailgullEntity.this.getRandomLocation();
            if (Vector3d != null) {
                PathNavigation navigator = FailgullEntity.this.getNavigation();
                navigator.moveTo(navigator.createPath(Vector3d, 1), 1.0);
            }
        }
    }

    class FollowLeaderGoal
    extends Goal {
        FollowLeaderGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private boolean canFollow() {
            return !FailgullEntity.this.getIsFlockLeader() && FailgullEntity.this.hasFlockLeader();
        }

        public boolean canUse() {
            return this.canFollow() && FailgullEntity.this.getNavigation().isDone() && FailgullEntity.this.random.nextInt(10) == 0;
        }

        public boolean canContinueToUse() {
            return this.canFollow() && FailgullEntity.this.getNavigation().isInProgress();
        }

        public void start() {
            Entity flockLeader = FailgullEntity.this.getFlockLeader();
            PathNavigation navigator = FailgullEntity.this.getNavigation();
            if (flockLeader != null && flockLeader.getType() == TropicraftEntities.FAILGULL.get()) {
                navigator.moveTo(navigator.createPath(flockLeader.blockPosition(), 1), 1.0);
                return;
            }
            BlockPos Vector3d = FailgullEntity.this.getRandomLocation();
            if (Vector3d != null) {
                navigator.moveTo(navigator.createPath(Vector3d, 1), 1.0);
            }
        }
    }
}

