/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.entity.TropicraftEntities;

public class GibnutEntity
extends Animal {
    private static final EntityDataAccessor<Boolean> DATA_VIBING = SynchedEntityData.defineId(GibnutEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public GibnutEntity(EntityType<? extends GibnutEntity> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, this::isFood, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(TropicraftTags.Items.FRUITS);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        GibnutEntity partner;
        GibnutEntity child = (GibnutEntity)((EntityType)TropicraftEntities.GIBNUT.get()).create((Level)level, EntitySpawnReason.BREEDING);
        if (child != null && (this.isVibing() || otherParent instanceof GibnutEntity && (partner = (GibnutEntity)otherParent).isVibing())) {
            child.setVibing(true);
        }
        return child;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VIBING, (Object)false);
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setVibing(input.getBooleanOr("vibing", false));
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putBoolean("vibing", this.isVibing());
    }

    public void setVibing(boolean vibing) {
        this.getEntityData().set(DATA_VIBING, (Object)vibing);
    }

    public boolean isVibing() {
        return (Boolean)this.getEntityData().get(DATA_VIBING);
    }
}

