/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class HummingbirdEntity
extends Animal
implements FlyingAnimal {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final int POLLINATE_THRESHOLD = 5;
    private int pollenCollected;

    public HummingbirdEntity(EntityType<? extends HummingbirdEntity> type, Level world) {
        super(type, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.FLYING_SPEED, 0.4).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation navigator = new FlyingPathNavigation((Mob)this, world);
        navigator.setCanOpenDoors(false);
        navigator.setCanFloat(true);
        return navigator;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FlyAwayInPanicGoal());
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, item -> item.is(Items.SUGAR), false));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new FeedFromPlantsGoal());
        this.goalSelector.addGoal(5, (Goal)new FlyAroundRandomlyGoal());
    }

    public static boolean canHummingbirdSpawnOn(EntityType<HummingbirdEntity> type, LevelAccessor world, EntitySpawnReason reason, BlockPos pos, RandomSource random) {
        BlockState groundState = world.getBlockState(pos.below());
        return (groundState.is(BlockTags.LEAVES) || groundState.is(Blocks.GRASS_BLOCK) || groundState.isAir()) && world.getRawBrightness(pos, 0) > 8;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public boolean causeFallDamage(double distance, float multiplier, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public HummingbirdEntity getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    private void tryPollinatePlant(BlockPos pos) {
        if (++this.pollenCollected >= 5) {
            this.pollenCollected = 0;
            this.tryGrowPlant(pos);
        }
    }

    private void tryGrowPlant(BlockPos pos) {
        BlockState state = this.level().getBlockState(pos);
        IntegerProperty age = this.getPlantAgeProperty(state);
        if (age != null) {
            int nextAge = (Integer)state.getValue((Property)age) + 1;
            if (age.getPossibleValues().contains(nextAge)) {
                this.level().levelEvent(1505, pos, 0);
                this.level().setBlockAndUpdate(pos, (BlockState)state.setValue((Property)age, (Comparable)Integer.valueOf(nextAge)));
            }
        }
    }

    @Nullable
    private IntegerProperty getPlantAgeProperty(BlockState state) {
        if (state.hasProperty((Property)BlockStateProperties.AGE_3)) {
            return BlockStateProperties.AGE_3;
        }
        if (state.hasProperty((Property)BlockStateProperties.AGE_7)) {
            return BlockStateProperties.AGE_7;
        }
        return null;
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putByte("pollen_collected", (byte)this.pollenCollected);
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.pollenCollected = input.getByteOr("pollen_collected", (byte)0);
    }

    final class FlyAwayInPanicGoal
    extends FlyingGoal {
        FlyAwayInPanicGoal() {
            super(1.25f);
        }

        @Override
        public boolean canUse() {
            return HummingbirdEntity.this.getLastHurtByMob() != null;
        }

        @Override
        @Nullable
        Vec3 generateTarget() {
            LivingEntity target = HummingbirdEntity.this.getLastHurtByMob();
            if (target == null) {
                return null;
            }
            Vec3 direction = HummingbirdEntity.this.position().subtract(target.position()).normalize();
            return this.generateTargetInDirection(direction, 1.5707963267948966);
        }
    }

    final class FeedFromPlantsGoal
    extends FlyingGoal {
        private static final int SEARCH_TRIES = 50;
        private static final int SEARCH_RADIUS = 5;
        private static final int SEARCH_RADIUS_Y = 3;
        private static final int FEEDING_TICKS = 80;
        private int feedingTicks;
        private boolean foundFood;

        FeedFromPlantsGoal() {
            super(1.0f);
        }

        @Override
        public boolean canUse() {
            HummingbirdEntity bird = HummingbirdEntity.this;
            return bird.navigation.isDone() && bird.random.nextInt(20) == 0;
        }

        @Override
        public boolean canContinueToUse() {
            return this.feedingTicks > 0 || HummingbirdEntity.this.isPathFinding();
        }

        @Override
        public void stop() {
            super.stop();
            this.feedingTicks = 0;
            this.foundFood = false;
        }

        public void tick() {
            super.tick();
            Vec3 target = this.target;
            if (target != null) {
                if (this.foundFood) {
                    this.tickFoundFood(target);
                } else {
                    this.tickFindingFood(target);
                }
            }
        }

        private void tickFoundFood(Vec3 target) {
            if (this.feedingTicks > 0) {
                HummingbirdEntity bird = HummingbirdEntity.this;
                bird.lookControl.setLookAt(target);
                if (--this.feedingTicks == 0) {
                    bird.tryPollinatePlant(BlockPos.containing((Position)target));
                }
            }
        }

        private void tickFindingFood(Vec3 target) {
            if (HummingbirdEntity.this.distanceToSqr(target) <= 2.25) {
                this.feedingTicks = 80;
                this.foundFood = true;
            }
        }

        @Override
        @Nullable
        Vec3 generateTarget() {
            HummingbirdEntity bird = HummingbirdEntity.this;
            Level world = bird.level();
            RandomSource random = bird.random;
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int i = 0; i < 50; ++i) {
                mutablePos.setWithOffset((Vec3i)bird.blockPosition(), random.nextInt(5) - random.nextInt(5), random.nextInt(3) - random.nextInt(3), random.nextInt(5) - random.nextInt(5));
                BlockState state = world.getBlockState((BlockPos)mutablePos);
                if (!this.canFeedFrom(world, (BlockPos)mutablePos, state)) continue;
                return Vec3.atCenterOf((Vec3i)mutablePos);
            }
            return null;
        }

        private boolean canFeedFrom(Level world, BlockPos pos, BlockState state) {
            if (this.canFeedFrom(state)) {
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (Direction direction : HORIZONTALS) {
                    mutablePos.setWithOffset((Vec3i)pos, direction);
                    if (!world.isEmptyBlock((BlockPos)mutablePos)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        private boolean canFeedFrom(BlockState state) {
            if (state.isAir()) {
                return false;
            }
            return state.is(BlockTags.LEAVES) || state.is(BlockTags.FLOWERS) || state.is(BlockTags.BEE_GROWABLES);
        }
    }

    final class FlyAroundRandomlyGoal
    extends FlyingGoal {
        FlyAroundRandomlyGoal() {
            super(1.0f);
        }

        @Override
        public boolean canUse() {
            HummingbirdEntity bird = HummingbirdEntity.this;
            return bird.navigation.isDone() && bird.random.nextInt(10) == 0;
        }

        @Override
        @Nullable
        Vec3 generateTarget() {
            Vec3 direction = HummingbirdEntity.this.getViewVector(1.0f);
            return this.generateTargetInDirection(direction, 1.5707963267948966);
        }
    }

    abstract class FlyingGoal
    extends Goal {
        final float speed;
        @Nullable
        Vec3 target;

        FlyingGoal(float speed) {
            this.speed = speed;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return HummingbirdEntity.this.navigation.isDone();
        }

        public boolean canContinueToUse() {
            return HummingbirdEntity.this.navigation.isInProgress();
        }

        public void start() {
            this.target = this.generateTarget();
            if (this.target != null) {
                Path path = HummingbirdEntity.this.navigation.createPath(BlockPos.containing((Position)this.target), 1);
                HummingbirdEntity.this.navigation.moveTo(path, (double)this.speed);
            }
        }

        public void stop() {
            this.target = null;
        }

        @Nullable
        abstract Vec3 generateTarget();

        @Nullable
        final Vec3 generateTargetInDirection(Vec3 direction, double maxAngle) {
            Vec3 target = HoverRandomPos.getPos((PathfinderMob)HummingbirdEntity.this, (int)8, (int)7, (double)direction.x, (double)direction.z, (float)((float)maxAngle), (int)2, (int)1);
            return target != null ? target : AirAndWaterRandomPos.getPos((PathfinderMob)HummingbirdEntity.this, (int)8, (int)4, (int)-2, (double)direction.x, (double)direction.z, (double)((float)maxAngle));
        }
    }
}

