/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import com.mojang.serialization.Codec;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.BinaryAnimation;
import net.tropicraft.core.common.entity.IkWalker;

public class ShoebillStorkEntity
extends Animal {
    public static final float BASE_FOOT_Z = 0.0152f;
    private static final int KICK_SHOES_TICKS = 20;
    private static final int KICK_SHOES_DROP_TICKS = 13;
    private static final byte EVENT_KICK_SHOES = 45;
    private static final Codec<HolderSet<Item>> ITEM_SET_CODEC = RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM);
    private final IkWalker walker = new IkWalker(6, 4, 20, 0.25f);
    private final IkWalker.Foot leftFoot = this.walker.addFoot(0.0152f, -0.1168f);
    private final IkWalker.Foot rightFoot = this.walker.addFoot(0.0152f, 0.1168f);
    private final BinaryAnimation flightAnimation = new BinaryAnimation(3, Mth::easeInOutSine);
    @Nullable
    private HolderSet<Item> wantedShoes;
    private boolean pickyAboutShoes;
    private boolean kickingShoes;
    private int kickingShoesTicks;

    public ShoebillStorkEntity(EntityType<? extends ShoebillStorkEntity> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.08);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RejectShoesGoal());
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, item -> item.is(ItemTags.FISHES), false));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            Vec3 deltaMovement = this.getDeltaMovement();
            if (!this.moveControl.hasWanted() && !this.onGround() && deltaMovement.y < 0.0) {
                this.setDeltaMovement(deltaMovement.multiply(1.0, 0.8, 1.0));
            }
        }
        if (this.kickingShoes) {
            ++this.kickingShoesTicks;
            if (this.kickingShoesTicks > 20) {
                this.kickingShoes = false;
                this.kickingShoesTicks = 0;
            } else if (this.kickingShoesTicks == 13 && !this.level().isClientSide()) {
                ItemStack itemStack = this.getItemBySlot(EquipmentSlot.FEET);
                this.setItemSlot(EquipmentSlot.FEET, ItemStack.EMPTY);
                this.drop(itemStack, false, true);
            }
        }
    }

    public void calculateEntityAnimation(boolean includeHeight) {
        super.calculateEntityAnimation(includeHeight);
        if (this.level().isClientSide()) {
            this.flightAnimation.tick(!this.onGround());
            this.walker.update((Mob)this);
        }
    }

    public void absSnapTo(double x, double y, double z) {
        super.absSnapTo(x, y, z);
        this.walker.reset((Mob)this);
    }

    public void snapTo(double x, double y, double z, float yRot, float xRot) {
        super.snapTo(x, y, z, yRot, xRot);
        this.walker.reset((Mob)this);
    }

    public IkWalker.Foot leftFoot() {
        return this.leftFoot;
    }

    public IkWalker.Foot rightFoot() {
        return this.rightFoot;
    }

    public float getFlightAnimation(float partialTicks) {
        return this.flightAnimation.get(partialTicks);
    }

    protected boolean canDispenserEquipIntoSlot(EquipmentSlot slot) {
        return super.canDispenserEquipIntoSlot(slot) || slot == EquipmentSlot.FEET;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public ShoebillStorkEntity getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 45) {
            this.startKickingShoes();
        }
    }

    private void startKickingShoes() {
        this.kickingShoes = true;
        this.level().broadcastEntityEvent((Entity)this, (byte)45);
    }

    private boolean wantsShoes(ItemStack itemBySlot) {
        return this.wantedShoes == null || itemBySlot.is(this.wantedShoes);
    }

    public float getKickAnimation(float partialTicks) {
        if (!this.kickingShoes) {
            return 0.0f;
        }
        return Math.min((float)this.kickingShoesTicks + partialTicks, 20.0f) / 20.0f;
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.storeNullable("wanted_shoes", ITEM_SET_CODEC, this.wantedShoes);
        output.putBoolean("picky_about_shoes", this.pickyAboutShoes);
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.wantedShoes = input.read("wanted_shoes", ITEM_SET_CODEC).orElse(null);
        this.pickyAboutShoes = input.getBooleanOr("picky_about_shoes", false);
    }

    private class RejectShoesGoal
    extends Goal {
        private static final int CHANCE_PER_TICK = 100;

        private RejectShoesGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            ItemStack feetItem = ShoebillStorkEntity.this.getItemBySlot(EquipmentSlot.FEET);
            if (feetItem.isEmpty() || ShoebillStorkEntity.this.wantsShoes(feetItem)) {
                return false;
            }
            return ShoebillStorkEntity.this.pickyAboutShoes || ShoebillStorkEntity.this.random.nextInt(this.adjustedTickDelay(100)) == 0;
        }

        public boolean canContinueToUse() {
            return ShoebillStorkEntity.this.kickingShoes;
        }

        public void start() {
            super.start();
            ShoebillStorkEntity.this.startKickingShoes();
        }
    }
}

