/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;

public class SmallBirdPathNavigation
extends FlyingPathNavigation {
    private static final float ADVANCE_THRESHOLD = 0.35f;

    public SmallBirdPathNavigation(Mob mob, Level level) {
        super(mob, level);
    }

    protected PathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new FlyNodeEvaluator();
        return new PathFinder(this, this.nodeEvaluator, maxVisitedNodes){

            protected float distance(Node first, Node second) {
                return first.distanceToXZ(second) + (float)Math.abs(first.y - second.y) * 4.0f;
            }
        };
    }

    @Nullable
    protected Path createPath(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
        Path path = super.createPath(targets, regionOffset, offsetUpward, accuracy, followRange);
        if (path != null && !path.canReach() && accuracy == 0) {
            return this.injectTargetNode(targets, path);
        }
        return path;
    }

    private Path injectTargetNode(Set<BlockPos> targets, Path path) {
        for (BlockPos target : targets) {
            Node endNode = path.getEndNode();
            if (endNode == null || endNode.distanceManhattan(target) != 1.0f) continue;
            ArrayList<Node> newNodes = new ArrayList<Node>(path.getNodeCount() + 1);
            for (int i = 0; i < path.getNodeCount(); ++i) {
                newNodes.add(path.getNode(i));
            }
            newNodes.add(endNode.cloneAndMove(target.getX(), target.getY(), target.getZ()));
            return new Path(newNodes, target, true);
        }
        return path;
    }

    protected void followThePath() {
        BlockPos nextBlock = this.path.getNextNodePos();
        Vec3 target = this.mob.onGround() ? Vec3.atBottomCenterOf((Vec3i)nextBlock) : Vec3.atCenterOf((Vec3i)nextBlock);
        double deltaX = Math.abs(this.mob.getX() - target.x);
        double deltaY = Math.abs(this.mob.getY() - target.y);
        double deltaZ = Math.abs(this.mob.getZ() - target.z);
        if (deltaX <= (double)0.35f && deltaZ <= (double)0.35f && deltaY <= (double)0.35f) {
            this.path.advance();
        }
        this.doStuckDetection(this.getTempMobPos());
    }
}

