/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.tropicraft.core.common.BinaryAnimation;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.entity.ai.BirdWanderInTreesGoal;
import net.tropicraft.core.common.entity.passive.BirdMoveControl;
import net.tropicraft.core.common.entity.passive.SmallBirdPathNavigation;

public class ToucanEntity
extends Animal
implements FlyingAnimal {
    private final BinaryAnimation flightAnimation = new BinaryAnimation(5, Mth::easeInOutSine);

    public ToucanEntity(EntityType<? extends ToucanEntity> type, Level world) {
        super(type, world);
        this.moveControl = new BirdMoveControl((Mob)this);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.FLYING_SPEED, 0.4).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    protected PathNavigation createNavigation(Level level) {
        SmallBirdPathNavigation navigator = new SmallBirdPathNavigation((Mob)this, level);
        navigator.setCanOpenDoors(false);
        navigator.setCanFloat(true);
        return navigator;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, item -> item.is(TropicraftTags.Items.FRUITS), false));
        this.goalSelector.addGoal(3, (Goal)new BirdWanderInTreesGoal((PathfinderMob)this, 1.0));
    }

    public static boolean canToucanSpawnOn(EntityType<ToucanEntity> type, LevelAccessor world, EntitySpawnReason reason, BlockPos pos, RandomSource random) {
        BlockState groundState = world.getBlockState(pos.below());
        return (groundState.is(BlockTags.LEAVES) || groundState.is(Blocks.GRASS_BLOCK) || groundState.isAir()) && world.getRawBrightness(pos, 0) > 8;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.flightAnimation.tick(this.isFlying());
        }
    }

    public float getFlightAnimation(float partialTicks) {
        return this.flightAnimation.get(partialTicks);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public ToucanEntity getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public int getMaxFallDistance() {
        return 1;
    }
}

